/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.eventpipes.api;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface EventExecutor {
    public static final EventExecutor ASYNC = CompletableFuture::runAsync;
    public static final EventExecutor ON_THREAD = runnable -> {
        CompletableFuture completable = new CompletableFuture();
        try {
            runnable.run();
            completable.complete(null);
        }
        catch (Exception e) {
            completable.completeExceptionally(e);
        }
        return completable;
    };

    public static EventExecutor of(ExecutorService service) {
        return runnable -> CompletableFuture.runAsync(runnable, service);
    }

    public static EventExecutor upgrade(Consumer<Runnable> runnableConsumer) {
        return runnable -> {
            CompletableFuture completable = new CompletableFuture();
            runnableConsumer.accept(() -> {
                try {
                    runnable.run();
                    completable.complete(null);
                }
                catch (Exception e) {
                    completable.completeExceptionally(e);
                }
            });
            return completable;
        };
    }

    public static EventExecutor upgradeKeyed(final BiConsumer<Object, Runnable> keyedRunnableConsumer) {
        return new EventExecutor(){

            @Override
            public CompletableFuture<?> execute(Runnable runnable) {
                return this.executeKeyed(runnable, runnable);
            }

            @Override
            public CompletableFuture<?> executeKeyed(Object key, Runnable runnable) {
                CompletableFuture completable = new CompletableFuture();
                keyedRunnableConsumer.accept(key, () -> {
                    try {
                        runnable.run();
                        completable.complete(null);
                    }
                    catch (Exception e) {
                        completable.completeExceptionally(e);
                    }
                });
                return completable;
            }
        };
    }

    public CompletableFuture<?> execute(Runnable var1);

    default public CompletableFuture<?> executeKeyed(Object key, Runnable runnable) {
        return this.execute(runnable);
    }
}

