/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.lib.eventpipes.internal;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import pw.aru.lib.eventpipes.api.EventConsumer;
import pw.aru.lib.eventpipes.api.EventExecutor;
import pw.aru.lib.eventpipes.api.EventPipe;
import pw.aru.lib.eventpipes.api.EventPublisher;
import pw.aru.lib.eventpipes.api.EventSubscriber;
import pw.aru.lib.eventpipes.api.EventSubscription;
import pw.aru.lib.eventpipes.api.keyed.KeyedEventPipe;
import pw.aru.lib.eventpipes.api.keyed.KeyedEventPublisher;
import pw.aru.lib.eventpipes.api.keyed.KeyedEventSubscriber;
import pw.aru.lib.eventpipes.internal.DefaultEventPipe;
import pw.aru.lib.eventpipes.internal.Wrapper;

public class DefaultKeyedEventPipe<K, V>
implements KeyedEventPipe<K, V> {
    private final EventExecutor executor;
    private final Map<K, EventPipe<V>> pipes;

    public DefaultKeyedEventPipe(EventExecutor executor) {
        this.executor = executor;
        this.pipes = new ConcurrentHashMap<K, EventPipe<V>>();
    }

    @Override
    public CompletableFuture<Void> publish(K key, V value) {
        return this.pipeOf(key).publish(value);
    }

    @Override
    public EventSubscription<V> subscribe(K key, EventConsumer<V> consumer) {
        return this.pipeOf(key).subscribe(consumer);
    }

    private EventPipe<V> pipeOf(final K key) {
        return this.pipes.computeIfAbsent(key, ignored -> new DefaultEventPipe<V>(this.executor){

            @Override
            protected void onEmpty() {
                DefaultKeyedEventPipe.this.pipes.remove(key);
            }

            @Override
            protected CompletableFuture<?> onExecute(V event, EventConsumer<V> consumer) {
                return DefaultKeyedEventPipe.this.executor.executeKeyed(key, new DefaultEventPipe.EventRunnable(event, consumer));
            }
        });
    }

    @Override
    public KeyedEventSubscriber<K, V> subscriber() {
        return Wrapper.wrapSubscriber(this);
    }

    @Override
    public KeyedEventPublisher<K, V> publisher() {
        return Wrapper.wrapPublisher(this);
    }

    @Override
    public EventPipe<V> pipe(K key) {
        return new KeyedPipe(key);
    }

    @Override
    public EventSubscriber<V> subscriber(K key) {
        return Wrapper.wrapSubscriber(this.pipe(key));
    }

    @Override
    public EventPublisher<V> publisher(K key) {
        return Wrapper.wrapPublisher(this.pipe(key));
    }

    @Override
    public void close() {
        for (EventPipe<V> pipe : this.pipes.values()) {
            pipe.close();
        }
    }

    class KeyedPipe
    implements EventPipe<V> {
        private final K key;

        KeyedPipe(K key) {
            this.key = key;
        }

        @Override
        public CompletableFuture<Void> publish(V event) {
            return DefaultKeyedEventPipe.this.publish(this.key, event);
        }

        @Override
        public EventSubscription<V> subscribe(EventConsumer<V> consumer) {
            return DefaultKeyedEventPipe.this.subscribe(this.key, consumer);
        }

        @Override
        public EventSubscriber<V> subscriber() {
            return Wrapper.wrapSubscriber(this);
        }

        @Override
        public EventPublisher<V> publisher() {
            return Wrapper.wrapPublisher(this);
        }

        @Override
        public void close() {
            DefaultKeyedEventPipe.this.pipeOf(this.key).close();
        }
    }
}

