/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.lib.eventpipes.api;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public interface EventExecutor {
    public static final EventExecutor ASYNC = CompletableFuture::runAsync;
    public static final EventExecutor ON_THREAD = runnable -> {
        runnable.run();
        return CompletableFuture.completedFuture(null);
    };

    public static EventExecutor of(ExecutorService service) {
        return runnable -> CompletableFuture.runAsync(runnable, service);
    }

    public static EventExecutor upgrade(Consumer<Runnable> runnableConsumer) {
        return runnable -> {
            CompletableFuture completable = new CompletableFuture();
            runnableConsumer.accept(() -> {
                runnable.run();
                completable.complete(null);
            });
            return completable;
        };
    }

    public static EventExecutor upgradeKeyed(final BiConsumer<Object, Runnable> keyedRunnableConsumer) {
        return new EventExecutor(){

            @Override
            public CompletableFuture<?> execute(Runnable runnable) {
                return this.executeKeyed(runnable, runnable);
            }

            @Override
            public CompletableFuture<?> executeKeyed(Object key, Runnable runnable) {
                CompletableFuture completable = new CompletableFuture();
                keyedRunnableConsumer.accept(key, () -> {
                    runnable.run();
                    completable.complete(null);
                });
                return completable;
            }
        };
    }

    public CompletableFuture<?> execute(Runnable var1);

    default public CompletableFuture<?> executeKeyed(Object key, Runnable runnable) {
        return this.execute(runnable);
    }
}

