/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.lib.eventpipes.internal;

import java.util.concurrent.CompletableFuture;
import pw.aru.lib.eventpipes.api.EventConsumer;
import pw.aru.lib.eventpipes.api.EventPublisher;
import pw.aru.lib.eventpipes.api.EventSubscriber;
import pw.aru.lib.eventpipes.api.EventSubscription;
import pw.aru.lib.eventpipes.api.keyed.KeyedEventPublisher;
import pw.aru.lib.eventpipes.api.keyed.KeyedEventSubscriber;

public class Wrapper {
    public static <T> EventSubscriber<T> wrapSubscriber(EventSubscriber<T> wrapped) {
        return new WrappedSubscriber<T>(wrapped);
    }

    public static <K, V> KeyedEventSubscriber<K, V> wrapSubscriber(KeyedEventSubscriber<K, V> wrapped) {
        return new WrappedKeyedSubscriber<K, V>(wrapped);
    }

    public static <T> EventPublisher<T> wrapPublisher(EventPublisher<T> wrapped) {
        return new WrappedPublisher<T>(wrapped);
    }

    public static <K, V> KeyedEventPublisher<K, V> wrapPublisher(KeyedEventPublisher<K, V> wrapped) {
        return new WrappedKeyedPublisher<K, V>(wrapped);
    }

    private static class WrappedKeyedPublisher<K, V>
    implements KeyedEventPublisher<K, V> {
        private final KeyedEventPublisher<K, V> wrapped;

        WrappedKeyedPublisher(KeyedEventPublisher<K, V> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public CompletableFuture<Void> publish(K key, V value) {
            return this.wrapped.publish(key, value);
        }
    }

    private static class WrappedKeyedSubscriber<K, V>
    implements KeyedEventSubscriber<K, V> {
        private final KeyedEventSubscriber<K, V> wrapped;

        WrappedKeyedSubscriber(KeyedEventSubscriber<K, V> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public EventSubscription<V> subscribe(K key, EventConsumer<V> consumer) {
            return this.wrapped.subscribe(key, consumer);
        }
    }

    private static class WrappedPublisher<T>
    implements EventPublisher<T> {
        private final EventPublisher<T> wrapped;

        WrappedPublisher(EventPublisher<T> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public CompletableFuture<Void> publish(T event) {
            return this.wrapped.publish(event);
        }
    }

    private static class WrappedSubscriber<T>
    implements EventSubscriber<T> {
        private final EventSubscriber<T> wrapped;

        WrappedSubscriber(EventSubscriber<T> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public EventSubscription<T> subscribe(EventConsumer<T> consumer) {
            return this.wrapped.subscribe(consumer);
        }
    }
}

