/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.catnip.entityfinder;

import com.mewna.catnip.Catnip;
import com.mewna.catnip.cache.view.NamedCacheView;
import com.mewna.catnip.entity.Snowflake;
import com.mewna.catnip.entity.channel.Category;
import com.mewna.catnip.entity.channel.GuildChannel;
import com.mewna.catnip.entity.channel.TextChannel;
import com.mewna.catnip.entity.channel.VoiceChannel;
import com.mewna.catnip.entity.guild.Guild;
import com.mewna.catnip.entity.guild.GuildBan;
import com.mewna.catnip.entity.guild.Member;
import com.mewna.catnip.entity.guild.Role;
import com.mewna.catnip.entity.misc.Emoji;
import com.mewna.catnip.entity.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class EntityFinder {
    public static final Pattern DISCORD_ID = Pattern.compile("\\d{1,20}");
    public static final Pattern FULL_USER_REF = Pattern.compile("(\\S.{0,30}\\S)\\s*#(\\d{4})");
    public static final Pattern USER_MENTION = Pattern.compile("<@!?(\\d{1,20})>");
    public static final Pattern CHANNEL_MENTION = Pattern.compile("<#(\\d{1,20})>");
    public static final Pattern ROLE_MENTION = Pattern.compile("<@&(\\d{1,20})>");
    public static final Pattern EMOTE_MENTION = Pattern.compile("<:(.{2,32}):(\\d{1,20})>");

    private EntityFinder() {
    }

    public static Collection<User> findUsers(String query, Catnip catnip) {
        User user2;
        Matcher userMention = USER_MENTION.matcher(query);
        Matcher fullRefMatch = FULL_USER_REF.matcher(query);
        if (userMention.matches()) {
            user2 = (User)catnip.cache().users().getById(userMention.group(1));
            if (user2 != null) {
                return Collections.singleton(user2);
            }
        } else if (fullRefMatch.matches()) {
            String lowerName = fullRefMatch.group(1).toLowerCase();
            String discrim = fullRefMatch.group(2);
            Collection users = catnip.cache().users().find(user -> user.username().toLowerCase().equals(lowerName) && user.discriminator().equals(discrim));
            if (!users.isEmpty()) {
                return users;
            }
        } else if (DISCORD_ID.matcher(query).matches() && (user2 = (User)catnip.cache().users().getById(query)) != null) {
            return Collections.singleton(user2);
        }
        ArrayList exact = new ArrayList();
        ArrayList wrongcase = new ArrayList();
        ArrayList startswith = new ArrayList();
        ArrayList contains = new ArrayList();
        String lowerquery = query.toLowerCase();
        catnip.cache().users().forEach(user -> {
            String name = user.username();
            if (name.equals(query)) {
                exact.add(user);
            } else if (name.equalsIgnoreCase(query) && exact.isEmpty()) {
                wrongcase.add(user);
            } else if (name.toLowerCase().startsWith(lowerquery) && wrongcase.isEmpty()) {
                startswith.add(user);
            } else if (name.toLowerCase().contains(lowerquery) && startswith.isEmpty()) {
                contains.add(user);
            }
        });
        if (!exact.isEmpty()) {
            return Collections.unmodifiableCollection(exact);
        }
        if (!wrongcase.isEmpty()) {
            return Collections.unmodifiableCollection(wrongcase);
        }
        if (!startswith.isEmpty()) {
            return Collections.unmodifiableCollection(startswith);
        }
        return Collections.unmodifiableCollection(contains);
    }

    public static Collection<User> findBannedUsers(String query, Snowflake guild) {
        Collection bans = guild.catnip().rest().guild().getGuildBans(guild.id()).thenApply(u -> u.stream().map(GuildBan::user).collect(Collectors.toSet())).toCompletableFuture().join();
        String discrim = null;
        Matcher userMention = USER_MENTION.matcher(query);
        if (userMention.matches()) {
            String id = userMention.group(1);
            User user = (User)guild.catnip().cache().users().getById(id);
            if (user != null && bans.contains(user)) {
                return Collections.singleton(user);
            }
            for (User u2 : bans) {
                if (!u2.id().equals(id)) continue;
                return Collections.singleton(u2);
            }
        } else if (FULL_USER_REF.matcher(query).matches()) {
            discrim = query.substring(query.length() - 4);
            query = query.substring(0, query.length() - 5).trim();
        } else if (DISCORD_ID.matcher(query).matches()) {
            User user = (User)guild.catnip().cache().users().getById(query);
            if (user != null && bans.contains(user)) {
                return Collections.singleton(user);
            }
            for (User u3 : bans) {
                if (!u3.id().equals(query)) continue;
                return Collections.singleton(u3);
            }
        }
        ArrayList<User> exact = new ArrayList<User>();
        ArrayList<User> wrongcase = new ArrayList<User>();
        ArrayList<User> startswith = new ArrayList<User>();
        ArrayList<User> contains = new ArrayList<User>();
        String lowerQuery = query.toLowerCase();
        for (User u4 : bans) {
            if (discrim != null && !u4.discriminator().equals(discrim)) continue;
            if (u4.username().equals(query)) {
                exact.add(u4);
                continue;
            }
            if (exact.isEmpty() && u4.username().equalsIgnoreCase(query)) {
                wrongcase.add(u4);
                continue;
            }
            if (wrongcase.isEmpty() && u4.username().toLowerCase().startsWith(lowerQuery)) {
                startswith.add(u4);
                continue;
            }
            if (!startswith.isEmpty() || !u4.username().toLowerCase().contains(lowerQuery)) continue;
            contains.add(u4);
        }
        if (!exact.isEmpty()) {
            return Collections.unmodifiableCollection(exact);
        }
        if (!wrongcase.isEmpty()) {
            return Collections.unmodifiableCollection(wrongcase);
        }
        if (!startswith.isEmpty()) {
            return Collections.unmodifiableCollection(startswith);
        }
        return Collections.unmodifiableCollection(contains);
    }

    public static Collection<Member> findMembers(String query, Guild guild) {
        Member member2;
        Matcher userMention = USER_MENTION.matcher(query);
        Matcher fullRefMatch = FULL_USER_REF.matcher(query);
        if (userMention.matches()) {
            member2 = (Member)guild.members().getById(userMention.group(1));
            if (member2 != null) {
                return Collections.singleton(member2);
            }
        } else if (fullRefMatch.matches()) {
            String lowerName = fullRefMatch.group(1).toLowerCase();
            String discrim = fullRefMatch.group(2);
            Collection members = guild.members().find(member -> member.user().username().toLowerCase().equals(lowerName) && member.user().discriminator().equals(discrim));
            if (!members.isEmpty()) {
                return members;
            }
        } else if (DISCORD_ID.matcher(query).matches() && (member2 = (Member)guild.members().getById(query)) != null) {
            return Collections.singleton(member2);
        }
        ArrayList exact = new ArrayList();
        ArrayList wrongcase = new ArrayList();
        ArrayList startswith = new ArrayList();
        ArrayList contains = new ArrayList();
        String lowerquery = query.toLowerCase();
        guild.members().forEach(member -> {
            String name = member.user().username();
            String effName = member.effectiveName();
            if (name.equals(query) || effName.equals(query)) {
                exact.add(member);
            } else if ((name.equalsIgnoreCase(query) || effName.equalsIgnoreCase(query)) && exact.isEmpty()) {
                wrongcase.add(member);
            } else if ((name.toLowerCase().startsWith(lowerquery) || effName.toLowerCase().startsWith(lowerquery)) && wrongcase.isEmpty()) {
                startswith.add(member);
            } else if ((name.toLowerCase().contains(lowerquery) || effName.toLowerCase().contains(lowerquery)) && startswith.isEmpty()) {
                contains.add(member);
            }
        });
        if (!exact.isEmpty()) {
            return Collections.unmodifiableCollection(exact);
        }
        if (!wrongcase.isEmpty()) {
            return Collections.unmodifiableCollection(wrongcase);
        }
        if (!startswith.isEmpty()) {
            return Collections.unmodifiableCollection(startswith);
        }
        return Collections.unmodifiableCollection(contains);
    }

    public static Collection<GuildChannel> findChannels(String query, Catnip catnip) {
        return EntityFinder.genericChannelSearch(query, ChannelFilter.ANY, (NamedCacheView<GuildChannel>)catnip.cache().channels());
    }

    public static Collection<GuildChannel> findChannels(String query, Guild guild) {
        return EntityFinder.genericChannelSearch(query, ChannelFilter.ANY, (NamedCacheView<GuildChannel>)guild.channels());
    }

    public static Collection<TextChannel> findTextChannels(String query, Catnip catnip) {
        return EntityFinder.genericChannelSearch(query, ChannelFilter.TEXT, (NamedCacheView<GuildChannel>)catnip.cache().channels());
    }

    public static Collection<TextChannel> findTextChannels(String query, Guild guild) {
        return EntityFinder.genericChannelSearch(query, ChannelFilter.TEXT, (NamedCacheView<GuildChannel>)guild.channels());
    }

    public static Collection<VoiceChannel> findVoiceChannels(String query, Catnip catnip) {
        return EntityFinder.genericChannelSearch(query, ChannelFilter.VOICE, (NamedCacheView<GuildChannel>)catnip.cache().channels());
    }

    public static Collection<VoiceChannel> findVoiceChannels(String query, Guild guild) {
        return EntityFinder.genericChannelSearch(query, ChannelFilter.VOICE, (NamedCacheView<GuildChannel>)guild.channels());
    }

    public static Collection<Category> findCategories(String query, Catnip catnip) {
        return EntityFinder.genericChannelSearch(query, ChannelFilter.CATEGORY, (NamedCacheView<GuildChannel>)catnip.cache().channels());
    }

    public static Collection<Category> findCategories(String query, Guild guild) {
        return EntityFinder.genericChannelSearch(query, ChannelFilter.CATEGORY, (NamedCacheView<GuildChannel>)guild.channels());
    }

    public static Collection<Role> findRoles(String query, Guild guild) {
        Role role2;
        Matcher roleMention = ROLE_MENTION.matcher(query);
        if (roleMention.matches() ? (role2 = (Role)guild.roles().getById(roleMention.group(1))) != null && role2.mentionable() : DISCORD_ID.matcher(query).matches() && (role2 = (Role)guild.roles().getById(query)) != null) {
            return Collections.singleton(role2);
        }
        ArrayList exact = new ArrayList();
        ArrayList wrongcase = new ArrayList();
        ArrayList startswith = new ArrayList();
        ArrayList contains = new ArrayList();
        String lowerquery = query.toLowerCase();
        guild.roles().forEach(role -> {
            String name = role.name();
            if (name.equals(query)) {
                exact.add(role);
            } else if (name.equalsIgnoreCase(query) && exact.isEmpty()) {
                wrongcase.add(role);
            } else if (name.toLowerCase().startsWith(lowerquery) && wrongcase.isEmpty()) {
                startswith.add(role);
            } else if (name.toLowerCase().contains(lowerquery) && startswith.isEmpty()) {
                contains.add(role);
            }
        });
        if (!exact.isEmpty()) {
            return Collections.unmodifiableCollection(exact);
        }
        if (!wrongcase.isEmpty()) {
            return Collections.unmodifiableCollection(wrongcase);
        }
        if (!startswith.isEmpty()) {
            return Collections.unmodifiableCollection(startswith);
        }
        return Collections.unmodifiableCollection(contains);
    }

    public static Collection<Emoji> findEmojis(String query, Guild guild) {
        return EntityFinder.genericEmojiSearch(query, (NamedCacheView<Emoji.CustomEmoji>)guild.emojis());
    }

    public static Collection<Emoji> findEmojis(String query, Catnip catnip) {
        return EntityFinder.genericEmojiSearch(query, (NamedCacheView<Emoji.CustomEmoji>)catnip.cache().emojis());
    }

    private static <T extends GuildChannel> Collection<T> genericChannelSearch(String query, ChannelFilter<T> f, NamedCacheView<GuildChannel> cache) {
        Matcher channelMention = CHANNEL_MENTION.matcher(query);
        if (f.isMentionable() && channelMention.matches()) {
            GuildChannel c2 = (GuildChannel)cache.getById(channelMention.group(1));
            if (!f.canCast(c2)) {
                return null;
            }
            return Collections.singleton(f.cast(c2));
        }
        if (DISCORD_ID.matcher(query).matches()) {
            GuildChannel c3 = (GuildChannel)cache.getById(query);
            if (!f.canCast(c3)) {
                return null;
            }
            return Collections.singleton(f.cast(c3));
        }
        ArrayList exact = new ArrayList();
        ArrayList wrongcase = new ArrayList();
        ArrayList startswith = new ArrayList();
        ArrayList contains = new ArrayList();
        String lowerquery = query.toLowerCase();
        cache.forEach(c -> {
            if (!f.canCast((GuildChannel)c)) {
                return;
            }
            Object tc = f.cast((GuildChannel)c);
            String name = tc.name();
            if (name.equals(query)) {
                exact.add(tc);
            } else if (name.equalsIgnoreCase(query) && exact.isEmpty()) {
                wrongcase.add(tc);
            } else if (name.toLowerCase().startsWith(lowerquery) && wrongcase.isEmpty()) {
                startswith.add(tc);
            } else if (name.toLowerCase().contains(lowerquery) && startswith.isEmpty()) {
                contains.add(tc);
            }
        });
        if (!exact.isEmpty()) {
            return Collections.unmodifiableCollection(exact);
        }
        if (!wrongcase.isEmpty()) {
            return Collections.unmodifiableCollection(wrongcase);
        }
        if (!startswith.isEmpty()) {
            return Collections.unmodifiableCollection(startswith);
        }
        return Collections.unmodifiableCollection(contains);
    }

    private static Collection<Emoji> genericEmojiSearch(String query, NamedCacheView<Emoji.CustomEmoji> cache) {
        Matcher mentionMatcher = EMOTE_MENTION.matcher(query);
        if (DISCORD_ID.matcher(query).matches()) {
            Emoji emoji2 = (Emoji)cache.getById(query);
            if (emoji2 != null) {
                return Collections.singleton(emoji2);
            }
        } else if (mentionMatcher.matches()) {
            String emojiName = mentionMatcher.group(1);
            String emojiId = mentionMatcher.group(2);
            Emoji emoji3 = (Emoji)cache.getById(emojiId);
            if (emoji3 != null && emoji3.name().equals(emojiName)) {
                return Collections.singleton(emoji3);
            }
        }
        ArrayList exact = new ArrayList();
        ArrayList wrongcase = new ArrayList();
        ArrayList startswith = new ArrayList();
        ArrayList contains = new ArrayList();
        String lowerquery = query.toLowerCase();
        cache.forEach(emoji -> {
            String name = emoji.name();
            if (name.equals(query)) {
                exact.add(emoji);
            } else if (name.equalsIgnoreCase(query) && exact.isEmpty()) {
                wrongcase.add(emoji);
            } else if (name.toLowerCase().startsWith(lowerquery) && wrongcase.isEmpty()) {
                startswith.add(emoji);
            } else if (name.toLowerCase().contains(lowerquery) && startswith.isEmpty()) {
                contains.add(emoji);
            }
        });
        if (!exact.isEmpty()) {
            return Collections.unmodifiableCollection(exact);
        }
        if (!wrongcase.isEmpty()) {
            return Collections.unmodifiableCollection(wrongcase);
        }
        if (!startswith.isEmpty()) {
            return Collections.unmodifiableCollection(startswith);
        }
        return Collections.unmodifiableCollection(contains);
    }

    private static interface ChannelFilter<T extends GuildChannel> {
        public static final ChannelFilter<GuildChannel> ANY = new ChannelFilter<GuildChannel>(){

            @Override
            public boolean canCast(GuildChannel channel) {
                return true;
            }

            @Override
            public GuildChannel cast(GuildChannel channel) {
                return channel;
            }
        };
        public static final ChannelFilter<TextChannel> TEXT = new ChannelFilter<TextChannel>(){

            @Override
            public boolean isMentionable() {
                return true;
            }

            @Override
            public boolean canCast(GuildChannel channel) {
                return channel.isText();
            }

            @Override
            public TextChannel cast(GuildChannel channel) {
                return channel.asTextChannel();
            }
        };
        public static final ChannelFilter<VoiceChannel> VOICE = new ChannelFilter<VoiceChannel>(){

            @Override
            public boolean canCast(GuildChannel channel) {
                return channel.isVoice();
            }

            @Override
            public VoiceChannel cast(GuildChannel channel) {
                return channel.asVoiceChannel();
            }
        };
        public static final ChannelFilter<Category> CATEGORY = new ChannelFilter<Category>(){

            @Override
            public boolean canCast(GuildChannel channel) {
                return channel.isCategory();
            }

            @Override
            public Category cast(GuildChannel channel) {
                return channel.asCategory();
            }
        };

        default public boolean isMentionable() {
            return false;
        }

        public boolean canCast(GuildChannel var1);

        public T cast(GuildChannel var1);
    }
}

