/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.entities;

import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import pw.aru.libs.andeclient.annotations.SimpleData;

public interface AudioLoadResult {
    public static final AudioLoadResult NO_MATCHES = new AudioLoadResult(){

        public String toString() {
            return "AudioLoadResult#NO_MATCHES";
        }
    };
    public static final AudioLoadResult UNKNOWN = new AudioLoadResult(){

        public String toString() {
            return "AudioLoadResult#UNKNOWN";
        }
    };

    @SimpleData
    @Value.Immutable
    public static interface Failed
    extends AudioLoadResult {
        @CheckReturnValue
        @Nonnull
        public String cause();

        @CheckReturnValue
        @Nonnull
        public FriendlyException.Severity severity();

        default public FriendlyException asException() {
            return new FriendlyException(this.cause(), this.severity(), null);
        }
    }

    @SimpleData
    @Value.Immutable
    public static interface Track
    extends AudioLoadResult {
        @CheckReturnValue
        @Nonnull
        public AudioTrack track();
    }

    @SimpleData
    @Value.Immutable
    public static interface Playlist
    extends AudioLoadResult {
        @CheckReturnValue
        public boolean searchResults();

        @CheckReturnValue
        @Nonnull
        public String playlistName();

        @CheckReturnValue
        @Nonnull
        public List<AudioTrack> tracks();

        @CheckReturnValue
        @Nullable
        public AudioTrack selectedTrack();

        @CheckReturnValue
        public int selectedIndex();
    }
}

