/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.internal;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.Map;
import javax.annotation.Nonnull;
import org.json.JSONObject;
import pw.aru.libs.andeclient.entities.AndePlayer;
import pw.aru.libs.andeclient.entities.EntityState;
import pw.aru.libs.andeclient.entities.player.PlayerControls;
import pw.aru.libs.andeclient.entities.player.PlayerFilter;
import pw.aru.libs.andeclient.internal.AndePlayerImpl;
import pw.aru.libs.andeclient.util.AudioTrackUtil;

public class PlayerControlsImpl
implements PlayerControls {
    private final AndePlayerImpl player;

    PlayerControlsImpl(AndePlayerImpl player) {
        this.player = player;
    }

    @Override
    @Nonnull
    public AndePlayer player() {
        return this.player;
    }

    @Override
    @Nonnull
    public PlayerControls.Play play() {
        return new PlayAction();
    }

    @Override
    @Nonnull
    public PlayerControls.Action pause() {
        return new SimpleAction("pause", new JSONObject().put("pause", true));
    }

    @Override
    @Nonnull
    public PlayerControls.Action resume() {
        return new SimpleAction("pause", new JSONObject().put("pause", false));
    }

    @Override
    @Nonnull
    public PlayerControls.Action volume(int volume) {
        return new SimpleAction("volume", new JSONObject().put("volume", volume));
    }

    @Override
    @Nonnull
    public PlayerControls.Mixer mixer() {
        return new MixerAction();
    }

    @Override
    @Nonnull
    public PlayerControls.Action filters(PlayerFilter ... filters) {
        return new FiltersAction(filters);
    }

    @Override
    @Nonnull
    public PlayerControls.Action seek(long position) {
        return new SimpleAction("seek", new JSONObject().put("position", position));
    }

    @Override
    @Nonnull
    public PlayerControls.Action stop() {
        return new EmptyAction("stop");
    }

    private class FiltersAction
    extends AbstractAction {
        private final PlayerFilter[] filters;

        FiltersAction(PlayerFilter[] filters) {
            super("filters");
            this.filters = filters;
        }

        @Override
        protected JSONObject createPayload() {
            JSONObject json = new JSONObject();
            for (PlayerFilter filter : this.filters) {
                Map.Entry<String, JSONObject> entry = filter.updatePayload();
                json.put(entry.getKey(), (Object)entry.getValue());
            }
            return json;
        }
    }

    private class MixerAction
    extends AbstractAction
    implements PlayerControls.Mixer {
        MixerAction() {
            super("mixer");
        }

        @Override
        @Nonnull
        public PlayerControls.Mixer enable() {
            return this;
        }

        @Override
        @Nonnull
        public PlayerControls.Mixer disable() {
            return this;
        }

        @Override
        protected JSONObject createPayload() {
            return new JSONObject();
        }
    }

    private class PlayAction
    extends AbstractAction
    implements PlayerControls.Play {
        private String trackString;
        private Long start;
        private Long end;
        private boolean noReplace;
        private Boolean pause;
        private Integer volume;

        PlayAction() {
            super("play");
        }

        @Override
        @Nonnull
        public PlayerControls.Play track(@Nonnull String trackString) {
            this.trackString = trackString;
            return this;
        }

        @Override
        @Nonnull
        public PlayerControls.Play track(@Nonnull AudioTrack track) {
            return this.track(AudioTrackUtil.fromTrack(track));
        }

        @Override
        @Nonnull
        public PlayerControls.Play start(Long timestamp) {
            this.start = timestamp;
            return this;
        }

        @Override
        @Nonnull
        public PlayerControls.Play end(Long timestamp) {
            this.end = timestamp;
            return this;
        }

        @Override
        @Nonnull
        public PlayerControls.Play noReplace() {
            this.noReplace = true;
            return this;
        }

        @Override
        @Nonnull
        public PlayerControls.Play replacing() {
            this.noReplace = false;
            return this;
        }

        @Override
        @Nonnull
        public PlayerControls.Play pause(Boolean isPaused) {
            this.pause = isPaused;
            return this;
        }

        @Override
        @Nonnull
        public PlayerControls.Play volume(Integer volume) {
            this.volume = volume;
            return this;
        }

        @Override
        protected JSONObject createPayload() {
            if (this.trackString == null) {
                throw new IllegalStateException("track must not be null!");
            }
            JSONObject json = new JSONObject().put("track", (Object)this.trackString).put("noReplace", this.noReplace);
            if (this.start != null) {
                json.put("start", (Object)this.start);
            }
            if (this.end != null) {
                json.put("end", (Object)this.end);
            }
            if (this.pause != null) {
                json.put("pause", (Object)this.pause);
            }
            if (this.volume != null) {
                json.put("volume", (Object)this.volume);
            }
            return json;
        }
    }

    private class SimpleAction
    extends AbstractAction {
        private final JSONObject payload;

        SimpleAction(String op, JSONObject payload) {
            super(op);
            this.payload = payload;
        }

        @Override
        protected JSONObject createPayload() {
            return this.payload;
        }
    }

    private class EmptyAction
    extends AbstractAction {
        EmptyAction(String op) {
            super(op);
        }

        @Override
        protected JSONObject createPayload() {
            return new JSONObject();
        }
    }

    private abstract class AbstractAction
    implements PlayerControls.Action {
        private final String op;

        AbstractAction(String op) {
            this.op = op;
        }

        protected abstract JSONObject createPayload();

        @Override
        @Nonnull
        public PlayerControls execute() {
            if (PlayerControlsImpl.this.player.state == EntityState.DESTROYED) {
                throw new IllegalStateException("Destroyed AndePlayer, please create a new one with AndeClient#newPlayer.");
            }
            PlayerControlsImpl.this.player.node.handleOutgoing(this.createPayload().put("op", (Object)this.op).put("guildId", (Object)Long.toString(PlayerControlsImpl.this.player.guildId())));
            return PlayerControlsImpl.this;
        }
    }
}

