/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.internal;

import java.io.Closeable;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import pw.aru.libs.andeclient.internal.AndesiteNodeImpl;

class NodeWebSocket
implements WebSocket.Listener,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(NodeWebSocket.class);
    private final AndesiteNodeImpl node;
    private final URI uri;
    private final CompletableFuture<WebSocket> websocket;
    private final StringBuilder wsBuffer = new StringBuilder();
    private final int pingTimeout;
    private final ByteBuffer systemPingBuffer = ByteBuffer.allocate(8);
    int lastSystemPing = -1;
    int lastPayloadPing = -1;
    private boolean closed = false;
    private ScheduledFuture<?> systemPingTask;
    private CompletableFuture<Void> systemPingFuture;
    private ScheduledFuture<?> payloadPingTask;
    private CompletableFuture<Void> payloadPingFuture;

    NodeWebSocket(AndesiteNodeImpl node, HttpClient client, URI uri, String userId, @Nullable String authentication, @Nullable String connectionId, int timeout) {
        this.node = node;
        this.uri = uri;
        this.pingTimeout = timeout;
        this.websocket = new CompletableFuture();
        WebSocket.Builder builder = client.newWebSocketBuilder().header("User-Id", userId);
        if (authentication != null) {
            builder.header("Authorization", authentication);
        }
        if (connectionId != null) {
            builder.header("Andesite-Connection-Id", connectionId);
        }
        builder.buildAsync(uri, this);
    }

    @Override
    public void onOpen(WebSocket ws) {
        this.websocket.complete(ws);
        ws.request(1L);
        try (MDC.MDCCloseable ignored = MDC.putCloseable((String)"websocket_url", (String)this.uri.toString());){
            logger.info("Connected!");
        }
        this.node.handleOpen();
        this.systemPingTask = this.node.client.executor.scheduleWithFixedDelay(this::doSystemPing, 10L, 10L, TimeUnit.SECONDS);
        this.payloadPingTask = this.node.client.executor.scheduleWithFixedDelay(this::doPayloadPing, 10L, 10L, TimeUnit.SECONDS);
    }

    private void doSystemPing() {
        try {
            WebSocket ws = this.websocket.get(this.pingTimeout, TimeUnit.MILLISECONDS);
            this.systemPingBuffer.asLongBuffer().position(0).put(System.currentTimeMillis()).flip();
            this.systemPingFuture = new CompletableFuture();
            ws.sendPing(this.systemPingBuffer);
            this.systemPingFuture.get(this.pingTimeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.node.handleTimeout();
        }
        catch (InterruptedException | ExecutionException e) {
            try (MDC.MDCCloseable ignored = MDC.putCloseable((String)"websocket_url", (String)this.uri.toString());){
                logger.error("Error while pinging websocket.", (Throwable)e);
            }
        }
    }

    private void doPayloadPing() {
        try {
            WebSocket ws = this.websocket.get(this.pingTimeout, TimeUnit.MILLISECONDS);
            this.payloadPingFuture = new CompletableFuture();
            ws.sendText(new JSONObject().put("op", (Object)"ping").toString(), true);
            this.payloadPingFuture.get(this.pingTimeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.node.handleTimeout();
        }
        catch (InterruptedException | ExecutionException e) {
            try (MDC.MDCCloseable ignored = MDC.putCloseable((String)"websocket_url", (String)this.uri.toString());){
                logger.error("Error while pinging node.", (Throwable)e);
            }
        }
    }

    @Override
    public CompletionStage<?> onClose(WebSocket ws, int statusCode, String reason) {
        if (!this.closed) {
            logger.error("Websocket closed unexplicably with code {} and reason '{}'.", (Object)statusCode, (Object)reason);
            this.closed = true;
            this.node.handleClose();
        }
        return null;
    }

    @Override
    public CompletionStage<?> onPong(WebSocket ws, ByteBuffer message) {
        this.systemPingFuture.complete(null);
        ws.request(1L);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> onText(WebSocket ws, CharSequence data, boolean last) {
        this.wsBuffer.append(data);
        if (last) {
            try {
                JSONObject json = new JSONObject(this.wsBuffer.toString());
                if (Objects.equals(json.optString("op", null), "pong")) {
                    this.payloadPingFuture.complete(null);
                } else {
                    this.node.handleIncoming(json);
                }
            }
            catch (Exception e) {
                try (MDC.MDCCloseable ignored = MDC.putCloseable((String)"websocket_url", (String)this.uri.toString());){
                    logger.error("Received payload that it's not valid json.", (Throwable)e);
                    logger.trace("Websocket Buffer: {}", (Object)this.wsBuffer.toString());
                }
            }
            finally {
                this.wsBuffer.setLength(0);
            }
        }
        ws.request(1L);
        return null;
    }

    @Override
    public void onError(WebSocket ws, Throwable t) {
        try (MDC.MDCCloseable ignored = MDC.putCloseable((String)"websocket_url", (String)this.uri.toString());){
            logger.error("Websocket errored", t);
        }
        this.node.handleError();
    }

    void send(JSONObject json) {
        this.websocket.thenComposeAsync(ws -> ws.sendText(json.toString(), true));
    }

    @Override
    public void close() {
        this.websocket.thenComposeAsync(ws -> ws.sendClose(1000, "Requested by client."));
        this.closed = true;
        if (this.systemPingTask != null) {
            this.systemPingTask.cancel(true);
        }
        if (this.payloadPingTask != null) {
            this.payloadPingTask.cancel(true);
        }
    }

    void destroy() {
        this.closed = true;
        this.websocket.thenAcceptAsync(WebSocket::abort);
    }
}

