/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.events.track.internal;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pw.aru.libs.andeclient.entities.AndePlayer;
import pw.aru.libs.andeclient.events.AndePlayerEvent;
import pw.aru.libs.andeclient.events.RemoteTrackEvent;
import pw.aru.libs.andeclient.events.track.TrackExceptionEvent;
import pw.aru.libs.andeclient.exceptions.RemoteTrackException;

@ParametersAreNonnullByDefault
@Generated(from="pw.aru.libs.andeclient.events.track.TrackExceptionEvent", generator="Immutables")
@Immutable
public final class PostedTrackExceptionEvent
extends TrackExceptionEvent {
    private final AndePlayer player;
    private final AudioTrack track;
    private final RemoteTrackException exception;

    private PostedTrackExceptionEvent(Builder builder) {
        this.player = builder.player;
        this.track = builder.track;
        this.exception = builder.exception;
    }

    @Override
    public AndePlayer player() {
        return this.player;
    }

    @Override
    public AudioTrack track() {
        return this.track;
    }

    @Override
    public RemoteTrackException exception() {
        return this.exception;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PostedTrackExceptionEvent && this.equalTo((PostedTrackExceptionEvent)another);
    }

    private boolean equalTo(PostedTrackExceptionEvent another) {
        return this.player.equals(another.player) && this.track.equals(another.track) && this.exception.equals(another.exception);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.player.hashCode();
        h += (h << 5) + this.track.hashCode();
        h += (h << 5) + this.exception.hashCode();
        return h;
    }

    public String toString() {
        return "TrackExceptionEvent{player=" + this.player + ", track=" + this.track + ", exception=" + this.exception + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="pw.aru.libs.andeclient.events.track.TrackExceptionEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PLAYER = 1L;
        private static final long INIT_BIT_TRACK = 2L;
        private static final long INIT_BIT_EXCEPTION = 4L;
        private long initBits = 7L;
        @Nullable
        private AndePlayer player;
        @Nullable
        private AudioTrack track;
        @Nullable
        private RemoteTrackException exception;

        private Builder() {
        }

        public final Builder from(RemoteTrackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AndePlayerEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TrackExceptionEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AndePlayerEvent instance;
            long bits = 0L;
            if (object instanceof RemoteTrackEvent) {
                instance = (RemoteTrackEvent)object;
                if ((bits & 1L) == 0L) {
                    this.track(instance.track());
                    bits |= 1L;
                }
            }
            if (object instanceof AndePlayerEvent) {
                instance = (AndePlayerEvent)object;
                if ((bits & 2L) == 0L) {
                    this.player(instance.player());
                    bits |= 2L;
                }
            }
            if (object instanceof TrackExceptionEvent) {
                instance = (TrackExceptionEvent)object;
                this.exception(((TrackExceptionEvent)instance).exception());
                if ((bits & 1L) == 0L) {
                    this.track(((TrackExceptionEvent)instance).track());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.player(((TrackExceptionEvent)instance).player());
                    bits |= 2L;
                }
            }
        }

        public final Builder player(AndePlayer player) {
            this.player = Objects.requireNonNull(player, "player");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder track(AudioTrack track) {
            this.track = Objects.requireNonNull(track, "track");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder exception(RemoteTrackException exception) {
            this.exception = Objects.requireNonNull(exception, "exception");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public PostedTrackExceptionEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new PostedTrackExceptionEvent(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("player");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("track");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("exception");
            }
            return "Cannot build TrackExceptionEvent, some of required attributes are not set " + attributes;
        }
    }
}

