/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.internal;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pw.aru.lib.eventpipes.api.EventConsumer;
import pw.aru.lib.eventpipes.api.EventSubscription;
import pw.aru.libs.andeclient.entities.AndeClient;
import pw.aru.libs.andeclient.entities.AndesiteNode;
import pw.aru.libs.andeclient.entities.AudioLoadResult;
import pw.aru.libs.andeclient.entities.EntityState;
import pw.aru.libs.andeclient.entities.configurator.AndesiteNodeConfigurator;
import pw.aru.libs.andeclient.events.AndeClientEvent;
import pw.aru.libs.andeclient.events.AndesiteNodeEvent;
import pw.aru.libs.andeclient.events.EventType;
import pw.aru.libs.andeclient.events.node.internal.PostedNewNodeEvent;
import pw.aru.libs.andeclient.events.node.internal.PostedNodeStatsEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedWebSocketClosedEvent;
import pw.aru.libs.andeclient.events.track.internal.PostedTrackEndEvent;
import pw.aru.libs.andeclient.events.track.internal.PostedTrackExceptionEvent;
import pw.aru.libs.andeclient.events.track.internal.PostedTrackStartEvent;
import pw.aru.libs.andeclient.events.track.internal.PostedTrackStuckEvent;
import pw.aru.libs.andeclient.exceptions.RemoteTrackException;
import pw.aru.libs.andeclient.internal.AndeClientImpl;
import pw.aru.libs.andeclient.internal.AndePlayerImpl;
import pw.aru.libs.andeclient.internal.NodeWebSocket;
import pw.aru.libs.andeclient.util.AndesiteUtil;
import pw.aru.libs.andeclient.util.AudioTrackUtil;

public class AndesiteNodeImpl
implements AndesiteNode {
    private static final Logger logger = LoggerFactory.getLogger(AndesiteNodeImpl.class);
    final AndeClientImpl client;
    final Map<Long, AndePlayerImpl> children = new ConcurrentHashMap<Long, AndePlayerImpl>();
    private final String host;
    private final int timeout;
    private NodeWebSocket ws;
    private EntityState state = EntityState.CONFIGURING;
    private AndesiteNode.Info info;
    private AndesiteNode.Stats lastStats;
    private final int port;
    private final String password;
    private final String relativePath;
    private String connectionId;
    private ScheduledFuture<?> statsCacheTask;

    public AndesiteNodeImpl(AndesiteNodeConfigurator configurator) {
        this.client = (AndeClientImpl)configurator.client();
        this.host = configurator.host();
        this.port = configurator.port();
        this.password = configurator.password();
        this.relativePath = configurator.relativePath();
        this.timeout = configurator.timeout();
        this.client.nodes.add(this);
        this.client.events.publish((Object)PostedNewNodeEvent.of(this));
        this.ws = new NodeWebSocket(this, this.client.httpClient, this.nodeUri(), Long.toString(this.client.userId()), this.password, null, this.timeout);
    }

    @Override
    @Nonnull
    public AndeClient client() {
        return this.client;
    }

    @Override
    @Nonnull
    public EntityState state() {
        return this.state;
    }

    @Override
    @Nonnull
    public String host() {
        return this.host;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public String relativePath() {
        return this.relativePath;
    }

    @Override
    @Nonnull
    public AndesiteNode.Info nodeInfo() {
        return this.info;
    }

    @Override
    @Nonnull
    public CompletionStage<AndesiteNode.Stats> stats() {
        CompletableFuture<AndesiteNode.Stats> future = new CompletableFuture<AndesiteNode.Stats>();
        EventSubscription<AndeClientEvent> subscription = this.on(EventType.NODE_STATS_EVENT, e -> future.complete(e.stats()));
        future.thenRun(() -> subscription.close());
        return future;
    }

    @Override
    @Nonnull
    public CompletionStage<AudioLoadResult> loadTracksAsync(String identifier) {
        URI uri = URI.create(String.format("http://%s:%d/%s?identifier=%s", this.host, this.port, this.relativePath != null ? this.relativePath + "/loadtracks" : "loadtracks", URLEncoder.encode(identifier, StandardCharsets.UTF_8)));
        HttpRequest.Builder builder = HttpRequest.newBuilder().GET().uri(uri);
        if (this.password != null) {
            builder.header("Authorization", this.password);
        }
        return this.client.httpClient.sendAsync(builder.build(), HttpResponse.BodyHandlers.ofString()).thenApply(it -> AndesiteUtil.audioLoadResult(new JSONObject((String)it.body())));
    }

    @Override
    public EventSubscription<AndeClientEvent> on(EventConsumer<AndesiteNodeEvent> consumer) {
        return this.client.on((EventConsumer<AndeClientEvent>)((EventConsumer)event -> {
            if (event instanceof AndesiteNodeEvent && ((AndesiteNodeEvent)event).node() == this) {
                consumer.onEvent((Object)((AndesiteNodeEvent)event));
            }
        }));
    }

    void handleOpen() {
        this.state = EntityState.AVAILABLE;
        this.statsCacheTask = this.client.executor.scheduleAtFixedRate(this::cacheStats, 10L, 10L, TimeUnit.SECONDS);
        this.handleOutgoing(new JSONObject().put("op", (Object)"event-buffer").put("timeout", this.timeout));
    }

    void handleTimeout() {
        if (this.state == EntityState.DESTROYED) {
            return;
        }
        logger.warn("Connection to node timed out, reconnecting...");
        this.state = EntityState.CONFIGURING;
        this.reconnect();
    }

    void handleClose() {
        if (this.state == EntityState.DESTROYED) {
            return;
        }
        logger.warn("Connection to node closed by server, reconnecting...");
        this.state = EntityState.CONFIGURING;
        this.reconnect();
    }

    void handleError() {
        if (this.state == EntityState.DESTROYED) {
            return;
        }
        logger.warn("Connection to node errored, reconnecting...");
        this.state = EntityState.CONFIGURING;
        this.reconnect();
    }

    void handleIncoming(JSONObject json) {
        logger.trace("received incoming json from andesite | json is {}", (Object)json);
        try {
            switch (json.getString("op")) {
                case "connection-id": {
                    logger.trace("received connection-id from andesite, caching value");
                    this.connectionId = json.getString("id");
                    return;
                }
                case "metadata": {
                    logger.trace("received metadata from andesite, updating info");
                    this.info = AndesiteUtil.nodeInfo(json.getJSONObject("data"));
                    return;
                }
                case "event": {
                    switch (json.getString("type")) {
                        case "TrackStartEvent": {
                            AudioTrack track;
                            logger.trace("received event TrackStartEvent, publishing it");
                            AndePlayerImpl player = this.playerFromEvent(json);
                            if (player == null) {
                                logger.trace("player not on AndeClient, dropping update");
                                return;
                            }
                            player.playingTrack = track = AudioTrackUtil.fromString(json.getString("track"));
                            this.client.events.publish((Object)PostedTrackStartEvent.builder().player(player).track(track).build());
                            return;
                        }
                        case "TrackEndEvent": {
                            logger.trace("received event TrackEndEvent, publishing it");
                            AndePlayerImpl player = this.playerFromEvent(json);
                            if (player == null) {
                                logger.trace("player not on AndeClient, dropping update");
                                return;
                            }
                            AudioTrack track = AudioTrackUtil.fromString(json.getString("track"));
                            player.playingTrack = null;
                            this.client.events.publish((Object)PostedTrackEndEvent.builder().player(player).track(track).reason(AudioTrackEndReason.valueOf((String)json.getString("reason"))).build());
                            return;
                        }
                        case "TrackExceptionEvent": {
                            logger.trace("received event TrackExceptionEvent, publishing it");
                            AndePlayerImpl player = this.playerFromEvent(json);
                            if (player == null) {
                                logger.trace("player not on AndeClient, dropping update");
                                return;
                            }
                            AudioTrack track = AudioTrackUtil.fromString(json.getString("track"));
                            this.client.events.publish((Object)PostedTrackExceptionEvent.builder().player(player).track(track).exception(new RemoteTrackException(this.client, player, this, track, json.getString("error"))).build());
                            return;
                        }
                        case "TrackStuckEvent": {
                            logger.trace("received event TrackStuckEvent, publishing it");
                            AndePlayerImpl player = this.playerFromEvent(json);
                            if (player == null) {
                                logger.trace("player not on AndeClient, dropping update");
                                return;
                            }
                            AudioTrack track = AudioTrackUtil.fromString(json.getString("track"));
                            this.client.events.publish((Object)PostedTrackStuckEvent.builder().player(player).track(track).thresholdMs(json.getInt("thresholdMs")).build());
                            return;
                        }
                        case "WebSocketClosedEvent": {
                            logger.trace("received event WebSocketClosedEvent, publishing it");
                            AndePlayerImpl player = this.playerFromEvent(json);
                            if (player == null) {
                                logger.trace("player not on AndeClient, dropping event");
                                return;
                            }
                            player.playingTrack = null;
                            this.client.events.publish((Object)PostedWebSocketClosedEvent.builder().player(player).reason(json.getString("reason")).closeCode(json.getInt("code")).byRemote(json.getBoolean("byRemote")).build());
                            return;
                        }
                    }
                    logger.warn("received event of unknown type | raw json is {}", (Object)json);
                    return;
                }
                case "player-update": {
                    logger.trace("received player update, sending to player");
                    AndePlayerImpl player = this.playerFromEvent(json);
                    if (player == null) {
                        logger.trace("player not on AndeClient, dropping update");
                        return;
                    }
                    player.update(json.getJSONObject("state"));
                    return;
                }
                case "pong": {
                    logger.trace("received pong from andesite");
                    return;
                }
                case "stats": {
                    logger.trace("received stats from andesite, publishing it");
                    AndesiteNode.Stats stats = AndesiteUtil.nodeStats(this, json.getJSONObject("stats"));
                    this.client.events.publish((Object)PostedNodeStatsEvent.of(stats));
                    this.lastStats = stats;
                    return;
                }
            }
            logger.warn("Received unknown op | raw json is {}", (Object)json);
        }
        catch (Exception e) {
            logger.error("Errored while handling json " + json, (Throwable)e);
        }
    }

    void handleOutgoing(JSONObject json) {
        if (this.state == EntityState.DESTROYED) {
            return;
        }
        logger.trace("sending outgoing json to andesite | json is {}", (Object)json);
        this.ws.send(json);
    }

    @Nullable
    private AndePlayerImpl playerFromEvent(@Nonnull JSONObject json) {
        return this.client.players.get(Long.parseLong(json.getString("guildId")));
    }

    @Override
    public void destroy() {
        if (this.state == EntityState.DESTROYED) {
            return;
        }
        if (this.ws == null) {
            throw new IllegalStateException("AndesiteNode's websocket is null, it is either already closed or trying to connect to the node.");
        }
        logger.trace("received destroy call, destroying websocket and cleaning up...");
        this.ws.close();
        this.exitCleanup();
    }

    private URI nodeUri() {
        return URI.create(String.format("ws://%s:%d/%s", this.host, this.port, this.relativePath != null ? this.relativePath + "/websocket" : "websocket"));
    }

    private void cacheStats() {
        this.handleOutgoing(new JSONObject().put("op", (Object)"get-stats"));
    }

    private void reconnect() {
        this.ws.destroy();
        this.ws = new NodeWebSocket(this, this.client.httpClient, this.nodeUri(), Long.toString(this.client.userId()), this.password, this.connectionId, this.timeout);
    }

    private void exitCleanup() {
        this.statsCacheTask.cancel(true);
    }

    public String toString() {
        return "AndesiteNode(" + String.format("%s:%d", this.host, this.port) + ")";
    }
}

