/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.internal;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONObject;
import pw.aru.lib.eventpipes.api.EventConsumer;
import pw.aru.lib.eventpipes.api.EventSubscription;
import pw.aru.libs.andeclient.entities.AndeClient;
import pw.aru.libs.andeclient.entities.AndePlayer;
import pw.aru.libs.andeclient.entities.AndesiteNode;
import pw.aru.libs.andeclient.entities.EntityState;
import pw.aru.libs.andeclient.entities.configurator.AndePlayerConfigurator;
import pw.aru.libs.andeclient.entities.player.PlayerControls;
import pw.aru.libs.andeclient.entities.player.PlayerFilter;
import pw.aru.libs.andeclient.events.AndeClientEvent;
import pw.aru.libs.andeclient.events.AndePlayerEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedNewPlayerEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedPlayerRemovedEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedPlayerUpdateEvent;
import pw.aru.libs.andeclient.events.player.update.internal.PostedPlayerFilterUpdateEvent;
import pw.aru.libs.andeclient.events.player.update.internal.PostedPlayerPauseUpdateEvent;
import pw.aru.libs.andeclient.internal.AndeClientImpl;
import pw.aru.libs.andeclient.internal.AndesiteNodeImpl;
import pw.aru.libs.andeclient.internal.PlayerControlsImpl;
import pw.aru.libs.andeclient.util.AndesiteUtil;

public class AndePlayerImpl
implements AndePlayer {
    private final AndeClientImpl client;
    final AndesiteNodeImpl node;
    private final long guildId;
    AudioTrack playingTrack;
    private PlayerControlsImpl playerControls;
    private long time;
    private long position;
    private int volume;
    private boolean isPaused;
    private Collection<? extends PlayerFilter> filters = Set.of();
    EntityState state = EntityState.CONFIGURING;

    public AndePlayerImpl(AndePlayerConfigurator configurator) {
        this.client = (AndeClientImpl)configurator.client();
        this.node = (AndesiteNodeImpl)configurator.andesiteNode();
        this.guildId = configurator.guildId();
        if (this.client.players.containsKey(this.guildId)) {
            this.state = EntityState.DESTROYED;
            throw new IllegalStateException("There's already a player for that guild!");
        }
        if (this.node.state() == EntityState.DESTROYED) {
            this.state = EntityState.DESTROYED;
            throw new IllegalStateException("The AndesiteNode provided is already destroyed. please create a new AndePlayer with a valid AndesiteNode.");
        }
        this.node.children.put(this.guildId, this);
        this.client.players.put(this.guildId, this);
        this.client.events.publish((Object)PostedNewPlayerEvent.of(this));
        this.state = EntityState.AVAILABLE;
    }

    @Override
    @Nonnull
    public AndesiteNode connectedNode() {
        return this.node;
    }

    @Override
    @Nonnull
    public AndeClient client() {
        return this.client;
    }

    @Override
    @Nonnull
    public EntityState state() {
        return this.state;
    }

    @Override
    @Nonnull
    public PlayerControls controls() {
        if (this.state == EntityState.DESTROYED) {
            throw new IllegalStateException("Destroyed AndePlayer, please create a new one with AndeClient#newPlayer.");
        }
        if (this.playerControls == null) {
            this.playerControls = new PlayerControlsImpl(this);
        }
        return this.playerControls;
    }

    @Override
    public long guildId() {
        return this.guildId;
    }

    @Override
    public long serverTime() {
        return this.time;
    }

    @Override
    @Nullable
    public AudioTrack playingTrack() {
        return this.playingTrack;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public int volume() {
        return this.volume;
    }

    @Override
    public boolean paused() {
        return this.isPaused;
    }

    @Override
    public Collection<? extends PlayerFilter> filters() {
        return this.filters;
    }

    @Override
    public void handleVoiceServerUpdate(String sessionId, String voiceToken, String endpoint) {
        if (this.state == EntityState.DESTROYED) {
            throw new IllegalStateException("Destroyed AndePlayer, please create a new one with AndeClient#newPlayer.");
        }
        this.node.handleOutgoing(new JSONObject().put("op", (Object)"voice-server-update").put("guildId", (Object)Long.toString(this.guildId)).put("sessionId", (Object)sessionId).put("event", (Object)new JSONObject().put("endpoint", (Object)endpoint).put("token", (Object)voiceToken)));
    }

    @Override
    public void destroy() {
        if (this.state == EntityState.DESTROYED) {
            return;
        }
        this.node.handleOutgoing(new JSONObject().put("op", (Object)"destroy").put("guildId", (Object)Long.toString(this.guildId)));
        this.state = EntityState.DESTROYED;
        this.playerControls = null;
        this.node.children.remove(this.guildId);
        this.client.players.remove(this.guildId);
        this.client.events.publish((Object)PostedPlayerRemovedEvent.of(this));
    }

    void update(JSONObject json) {
        if (this.state == EntityState.DESTROYED) {
            return;
        }
        long lastTime = this.time;
        long lastPosition = this.position;
        int lastVolume = this.volume;
        boolean wasPaused = this.isPaused;
        Collection<? extends PlayerFilter> lastFilters = this.filters;
        long newTime = Long.parseLong(json.getString("time"));
        long newPosition = json.optInt("position", -1);
        int newVolume = json.getInt("volume");
        boolean newPaused = json.getBoolean("paused");
        Set<PlayerFilter> newFilters = AndesiteUtil.playerFilters(json.getJSONObject("filters"));
        this.time = newTime;
        this.position = newPosition;
        this.volume = newVolume;
        this.isPaused = newPaused;
        this.filters = newFilters;
        this.client.events.publish((Object)PostedPlayerUpdateEvent.builder().player(this).timestamp(newTime).position(newPosition).volume(newVolume).filters(newFilters).oldTimestamp(lastTime).oldPosition(lastPosition).build());
        if (wasPaused != newPaused) {
            this.client.events.publish((Object)PostedPlayerPauseUpdateEvent.of(this, newPaused));
        }
        if (lastVolume != newVolume) {
            this.client.events.publish((Object)PostedPlayerPauseUpdateEvent.of(this, newPaused));
        }
        if (!Objects.equals(lastFilters, newFilters)) {
            this.client.events.publish((Object)PostedPlayerFilterUpdateEvent.builder().player(this).filters(newFilters).oldFilters(lastFilters).build());
        }
    }

    @Override
    public EventSubscription<AndeClientEvent> on(EventConsumer<AndePlayerEvent> consumer) {
        return this.client.on((EventConsumer<AndeClientEvent>)((EventConsumer)event -> {
            if (this.state != EntityState.DESTROYED && event instanceof AndePlayerEvent && ((AndePlayerEvent)event).player() == this) {
                consumer.onEvent((Object)((AndePlayerEvent)event));
            }
        }));
    }

    public String toString() {
        return "AndePlayer(guildId=" + this.guildId + ", node=" + this.node + ")";
    }
}

