/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.entities.internal;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pw.aru.libs.andeclient.entities.AudioLoadResult;

@ParametersAreNonnullByDefault
@Generated(from="pw.aru.libs.andeclient.entities.AudioLoadResult.Playlist", generator="Immutables")
@Immutable
public final class ActualPlaylist
implements AudioLoadResult.Playlist {
    private final boolean searchResults;
    private final String playlistName;
    private final List<AudioTrack> tracks;
    @Nullable
    private final AudioTrack selectedTrack;
    private final int selectedIndex;

    private ActualPlaylist(Builder builder) {
        this.searchResults = builder.searchResults;
        this.playlistName = builder.playlistName;
        this.tracks = ActualPlaylist.createUnmodifiableList(true, builder.tracks);
        this.selectedTrack = builder.selectedTrack;
        this.selectedIndex = builder.selectedIndex;
    }

    @Override
    public boolean searchResults() {
        return this.searchResults;
    }

    @Override
    public String playlistName() {
        return this.playlistName;
    }

    @Override
    public List<AudioTrack> tracks() {
        return this.tracks;
    }

    @Override
    @Nullable
    public AudioTrack selectedTrack() {
        return this.selectedTrack;
    }

    @Override
    public int selectedIndex() {
        return this.selectedIndex;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ActualPlaylist && this.equalTo((ActualPlaylist)another);
    }

    private boolean equalTo(ActualPlaylist another) {
        return this.searchResults == another.searchResults && this.playlistName.equals(another.playlistName) && this.tracks.equals(another.tracks) && Objects.equals(this.selectedTrack, another.selectedTrack) && this.selectedIndex == another.selectedIndex;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.searchResults);
        h += (h << 5) + this.playlistName.hashCode();
        h += (h << 5) + this.tracks.hashCode();
        h += (h << 5) + Objects.hashCode(this.selectedTrack);
        h += (h << 5) + this.selectedIndex;
        return h;
    }

    public String toString() {
        return "Playlist{searchResults=" + this.searchResults + ", playlistName=" + this.playlistName + ", tracks=" + this.tracks + ", selectedTrack=" + this.selectedTrack + ", selectedIndex=" + this.selectedIndex + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="pw.aru.libs.andeclient.entities.AudioLoadResult.Playlist", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SEARCH_RESULTS = 1L;
        private static final long INIT_BIT_PLAYLIST_NAME = 2L;
        private static final long INIT_BIT_SELECTED_INDEX = 4L;
        private long initBits = 7L;
        private boolean searchResults;
        @Nullable
        private String playlistName;
        private List<AudioTrack> tracks = new ArrayList<AudioTrack>();
        @Nullable
        private AudioTrack selectedTrack;
        private int selectedIndex;

        private Builder() {
        }

        public final Builder from(AudioLoadResult.Playlist instance) {
            Objects.requireNonNull(instance, "instance");
            this.searchResults(instance.searchResults());
            this.playlistName(instance.playlistName());
            this.plusTracks(instance.tracks());
            AudioTrack selectedTrackValue = instance.selectedTrack();
            if (selectedTrackValue != null) {
                this.selectedTrack(selectedTrackValue);
            }
            this.selectedIndex(instance.selectedIndex());
            return this;
        }

        public final Builder searchResults(boolean searchResults) {
            this.searchResults = searchResults;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder playlistName(String playlistName) {
            this.playlistName = Objects.requireNonNull(playlistName, "playlistName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder plusTracks(AudioTrack element) {
            this.tracks.add(Objects.requireNonNull(element, "tracks element"));
            return this;
        }

        public final Builder plusTracks(AudioTrack ... elements) {
            for (AudioTrack element : elements) {
                this.tracks.add(Objects.requireNonNull(element, "tracks element"));
            }
            return this;
        }

        public final Builder tracks(Iterable<? extends AudioTrack> elements) {
            this.tracks.clear();
            return this.plusTracks(elements);
        }

        public final Builder plusTracks(Iterable<? extends AudioTrack> elements) {
            for (AudioTrack audioTrack : elements) {
                this.tracks.add(Objects.requireNonNull(audioTrack, "tracks element"));
            }
            return this;
        }

        public final Builder selectedTrack(@Nullable AudioTrack selectedTrack) {
            this.selectedTrack = selectedTrack;
            return this;
        }

        public final Builder selectedIndex(int selectedIndex) {
            this.selectedIndex = selectedIndex;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ActualPlaylist build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ActualPlaylist(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("searchResults");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("playlistName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("selectedIndex");
            }
            return "Cannot build Playlist, some of required attributes are not set " + attributes;
        }
    }
}

