/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.entities.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pw.aru.libs.andeclient.entities.AndesiteNode;

@ParametersAreNonnullByDefault
@Generated(from="pw.aru.libs.andeclient.entities.AndesiteNode.Info", generator="Immutables")
@Immutable
public final class ActualInfo
implements AndesiteNode.Info {
    private final String version;
    private final String versionMajor;
    private final String versionMinor;
    private final String versionRevision;
    private final long versionBuild;
    private final String versionCommit;
    private final String nodeRegion;
    private final String nodeId;
    private final List<String> enabledSources;
    private final List<String> loadedPlugins;

    private ActualInfo(Builder builder) {
        this.version = builder.version;
        this.versionMajor = builder.versionMajor;
        this.versionMinor = builder.versionMinor;
        this.versionRevision = builder.versionRevision;
        this.versionBuild = builder.versionBuild;
        this.versionCommit = builder.versionCommit;
        this.nodeRegion = builder.nodeRegion;
        this.nodeId = builder.nodeId;
        this.enabledSources = ActualInfo.createUnmodifiableList(true, builder.enabledSources);
        this.loadedPlugins = ActualInfo.createUnmodifiableList(true, builder.loadedPlugins);
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public String versionMajor() {
        return this.versionMajor;
    }

    @Override
    public String versionMinor() {
        return this.versionMinor;
    }

    @Override
    public String versionRevision() {
        return this.versionRevision;
    }

    @Override
    public long versionBuild() {
        return this.versionBuild;
    }

    @Override
    public String versionCommit() {
        return this.versionCommit;
    }

    @Override
    public String nodeRegion() {
        return this.nodeRegion;
    }

    @Override
    public String nodeId() {
        return this.nodeId;
    }

    @Override
    public List<String> enabledSources() {
        return this.enabledSources;
    }

    @Override
    public List<String> loadedPlugins() {
        return this.loadedPlugins;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ActualInfo && this.equalTo((ActualInfo)another);
    }

    private boolean equalTo(ActualInfo another) {
        return this.version.equals(another.version) && this.versionMajor.equals(another.versionMajor) && this.versionMinor.equals(another.versionMinor) && this.versionRevision.equals(another.versionRevision) && this.versionBuild == another.versionBuild && this.versionCommit.equals(another.versionCommit) && this.nodeRegion.equals(another.nodeRegion) && this.nodeId.equals(another.nodeId) && this.enabledSources.equals(another.enabledSources) && this.loadedPlugins.equals(another.loadedPlugins);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.versionMajor.hashCode();
        h += (h << 5) + this.versionMinor.hashCode();
        h += (h << 5) + this.versionRevision.hashCode();
        h += (h << 5) + Long.hashCode(this.versionBuild);
        h += (h << 5) + this.versionCommit.hashCode();
        h += (h << 5) + this.nodeRegion.hashCode();
        h += (h << 5) + this.nodeId.hashCode();
        h += (h << 5) + this.enabledSources.hashCode();
        h += (h << 5) + this.loadedPlugins.hashCode();
        return h;
    }

    public String toString() {
        return "Info{version=" + this.version + ", versionMajor=" + this.versionMajor + ", versionMinor=" + this.versionMinor + ", versionRevision=" + this.versionRevision + ", versionBuild=" + this.versionBuild + ", versionCommit=" + this.versionCommit + ", nodeRegion=" + this.nodeRegion + ", nodeId=" + this.nodeId + ", enabledSources=" + this.enabledSources + ", loadedPlugins=" + this.loadedPlugins + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="pw.aru.libs.andeclient.entities.AndesiteNode.Info", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VERSION = 1L;
        private static final long INIT_BIT_VERSION_MAJOR = 2L;
        private static final long INIT_BIT_VERSION_MINOR = 4L;
        private static final long INIT_BIT_VERSION_REVISION = 8L;
        private static final long INIT_BIT_VERSION_BUILD = 16L;
        private static final long INIT_BIT_VERSION_COMMIT = 32L;
        private static final long INIT_BIT_NODE_REGION = 64L;
        private static final long INIT_BIT_NODE_ID = 128L;
        private long initBits = 255L;
        @Nullable
        private String version;
        @Nullable
        private String versionMajor;
        @Nullable
        private String versionMinor;
        @Nullable
        private String versionRevision;
        private long versionBuild;
        @Nullable
        private String versionCommit;
        @Nullable
        private String nodeRegion;
        @Nullable
        private String nodeId;
        private List<String> enabledSources = new ArrayList<String>();
        private List<String> loadedPlugins = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(AndesiteNode.Info instance) {
            Objects.requireNonNull(instance, "instance");
            this.version(instance.version());
            this.versionMajor(instance.versionMajor());
            this.versionMinor(instance.versionMinor());
            this.versionRevision(instance.versionRevision());
            this.versionBuild(instance.versionBuild());
            this.versionCommit(instance.versionCommit());
            this.nodeRegion(instance.nodeRegion());
            this.nodeId(instance.nodeId());
            this.plusEnabledSources(instance.enabledSources());
            this.plusLoadedPlugins(instance.loadedPlugins());
            return this;
        }

        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder versionMajor(String versionMajor) {
            this.versionMajor = Objects.requireNonNull(versionMajor, "versionMajor");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder versionMinor(String versionMinor) {
            this.versionMinor = Objects.requireNonNull(versionMinor, "versionMinor");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder versionRevision(String versionRevision) {
            this.versionRevision = Objects.requireNonNull(versionRevision, "versionRevision");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder versionBuild(long versionBuild) {
            this.versionBuild = versionBuild;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder versionCommit(String versionCommit) {
            this.versionCommit = Objects.requireNonNull(versionCommit, "versionCommit");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder nodeRegion(String nodeRegion) {
            this.nodeRegion = Objects.requireNonNull(nodeRegion, "nodeRegion");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder nodeId(String nodeId) {
            this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder plusEnabledSources(String element) {
            this.enabledSources.add(Objects.requireNonNull(element, "enabledSources element"));
            return this;
        }

        public final Builder plusEnabledSources(String ... elements) {
            for (String element : elements) {
                this.enabledSources.add(Objects.requireNonNull(element, "enabledSources element"));
            }
            return this;
        }

        public final Builder enabledSources(Iterable<String> elements) {
            this.enabledSources.clear();
            return this.plusEnabledSources(elements);
        }

        public final Builder plusEnabledSources(Iterable<String> elements) {
            for (String element : elements) {
                this.enabledSources.add(Objects.requireNonNull(element, "enabledSources element"));
            }
            return this;
        }

        public final Builder plusLoadedPlugins(String element) {
            this.loadedPlugins.add(Objects.requireNonNull(element, "loadedPlugins element"));
            return this;
        }

        public final Builder plusLoadedPlugins(String ... elements) {
            for (String element : elements) {
                this.loadedPlugins.add(Objects.requireNonNull(element, "loadedPlugins element"));
            }
            return this;
        }

        public final Builder loadedPlugins(Iterable<String> elements) {
            this.loadedPlugins.clear();
            return this.plusLoadedPlugins(elements);
        }

        public final Builder plusLoadedPlugins(Iterable<String> elements) {
            for (String element : elements) {
                this.loadedPlugins.add(Objects.requireNonNull(element, "loadedPlugins element"));
            }
            return this;
        }

        public ActualInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ActualInfo(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("versionMajor");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("versionMinor");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("versionRevision");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("versionBuild");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("versionCommit");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("nodeRegion");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("nodeId");
            }
            return "Cannot build Info, some of required attributes are not set " + attributes;
        }
    }
}

