/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.internal;

import java.net.http.HttpClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import pw.aru.lib.eventpipes.EventPipes;
import pw.aru.lib.eventpipes.api.EventConsumer;
import pw.aru.lib.eventpipes.api.EventPipe;
import pw.aru.lib.eventpipes.api.EventSubscription;
import pw.aru.libs.andeclient.entities.AndeClient;
import pw.aru.libs.andeclient.entities.AndePlayer;
import pw.aru.libs.andeclient.entities.AndesiteNode;
import pw.aru.libs.andeclient.entities.EntityState;
import pw.aru.libs.andeclient.entities.LoadBalancer;
import pw.aru.libs.andeclient.entities.configurator.AndeClientConfigurator;
import pw.aru.libs.andeclient.entities.configurator.internal.ActualAndePlayerConfigurator;
import pw.aru.libs.andeclient.entities.configurator.internal.ActualAndesiteNodeConfigurator;
import pw.aru.libs.andeclient.events.AndeClientEvent;
import pw.aru.libs.andeclient.internal.AndePlayerImpl;
import pw.aru.libs.andeclient.internal.AndesiteNodeImpl;

public class AndeClientImpl
implements AndeClient {
    private final long userId;
    private final LoadBalancer loadBalancer;
    final ScheduledExecutorService executor;
    final HttpClient httpClient;
    final EventPipe<AndeClientEvent> events;
    final List<AndesiteNodeImpl> nodes = new CopyOnWriteArrayList<AndesiteNodeImpl>();
    final Map<Long, AndePlayerImpl> players = new ConcurrentHashMap<Long, AndePlayerImpl>();

    public AndeClientImpl(AndeClientConfigurator configurator) {
        this.userId = configurator.userId();
        this.httpClient = configurator.httpClient();
        this.loadBalancer = configurator.loadBalancer();
        this.executor = configurator.executor();
        this.events = EventPipes.newAsyncPipe((ExecutorService)this.executor);
    }

    @Override
    @Nonnull
    public ActualAndesiteNodeConfigurator newNode() {
        return new ActualAndesiteNodeConfigurator().client(this);
    }

    @Override
    @Nonnull
    public List<AndesiteNode> nodes() {
        return List.copyOf(this.nodes);
    }

    @Override
    @Nonnull
    public AndesiteNode bestNode() {
        if (this.nodes.isEmpty()) {
            throw new IllegalStateException("no nodes!");
        }
        if (this.nodes.size() == 1) {
            return this.nodes.get(0);
        }
        List stats = this.nodes.stream().filter(node -> node.state() == EntityState.AVAILABLE).map(AndesiteNode::stats).map(CompletionStage::toCompletableFuture).map(CompletableFuture::join).collect(Collectors.toUnmodifiableList());
        int bestPenalty = Integer.MAX_VALUE;
        AndesiteNode bestNode = null;
        for (AndesiteNode.Stats stat : stats) {
            int penalty = this.loadBalancer.totalPenalty(stat);
            if (penalty >= bestPenalty) continue;
            bestPenalty = penalty;
            bestNode = stat.node();
        }
        if (bestNode == null) {
            throw new IllegalStateException("no nodes!");
        }
        return bestNode;
    }

    @Override
    @Nonnull
    public ActualAndePlayerConfigurator newPlayer() {
        return new ActualAndePlayerConfigurator().client(this);
    }

    @Override
    @Nonnull
    public AndePlayer newPlayer(long guildId) {
        AndePlayerImpl player = this.players.get(guildId);
        if (player != null) {
            return player;
        }
        return new ActualAndePlayerConfigurator().client(this).guildId(guildId).andesiteNode(this.bestNode()).create();
    }

    @Override
    @Nonnull
    public List<AndePlayer> players() {
        return List.copyOf(this.players.values());
    }

    @Override
    @Nullable
    public AndePlayer player(long guildId) {
        return this.players.get(guildId);
    }

    @Override
    public EventSubscription<AndeClientEvent> on(EventConsumer<AndeClientEvent> consumer) {
        return this.events.subscribe(consumer);
    }

    @Override
    public long userId() {
        return this.userId;
    }

    @Override
    public void shutdown() {
        this.nodes.forEach(AndesiteNodeImpl::destroy);
        this.events.close();
        this.executor.shutdown();
    }

    public String toString() {
        return "AndeClient(userId=" + this.userId + ", nodes=" + this.nodes.size() + ", players=" + this.players.size() + ")";
    }
}

