/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.entities.player.internal;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pw.aru.libs.andeclient.entities.player.DefaultFilters;

@ParametersAreNonnullByDefault
@Generated(from="pw.aru.libs.andeclient.entities.player.DefaultFilters.Karaoke", generator="Immutables")
@Immutable
public final class KaraokeFilter
extends DefaultFilters.Karaoke {
    @Nullable
    private final Float level;
    @Nullable
    private final Float monoLevel;
    @Nullable
    private final Float filterBand;
    @Nullable
    private final Float filterWidth;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private KaraokeFilter(Builder builder) {
        if (builder.levelIsSet()) {
            this.initShim.level(builder.level);
        }
        if (builder.monoLevelIsSet()) {
            this.initShim.monoLevel(builder.monoLevel);
        }
        if (builder.filterBandIsSet()) {
            this.initShim.filterBand(builder.filterBand);
        }
        if (builder.filterWidthIsSet()) {
            this.initShim.filterWidth(builder.filterWidth);
        }
        this.level = this.initShim.level();
        this.monoLevel = this.initShim.monoLevel();
        this.filterBand = this.initShim.filterBand();
        this.filterWidth = this.initShim.filterWidth();
        this.initShim = null;
    }

    private KaraokeFilter(@Nullable Float level, @Nullable Float monoLevel, @Nullable Float filterBand, @Nullable Float filterWidth) {
        this.level = level;
        this.monoLevel = monoLevel;
        this.filterBand = filterBand;
        this.filterWidth = filterWidth;
        this.initShim = null;
    }

    @Override
    @Nullable
    public Float level() {
        InitShim shim = this.initShim;
        return shim != null ? shim.level() : this.level;
    }

    @Override
    @Nullable
    public Float monoLevel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.monoLevel() : this.monoLevel;
    }

    @Override
    @Nullable
    public Float filterBand() {
        InitShim shim = this.initShim;
        return shim != null ? shim.filterBand() : this.filterBand;
    }

    @Override
    @Nullable
    public Float filterWidth() {
        InitShim shim = this.initShim;
        return shim != null ? shim.filterWidth() : this.filterWidth;
    }

    public final KaraokeFilter withLevel(@Nullable Float value) {
        if (Objects.equals(this.level, value)) {
            return this;
        }
        return new KaraokeFilter(value, this.monoLevel, this.filterBand, this.filterWidth);
    }

    public final KaraokeFilter withMonoLevel(@Nullable Float value) {
        if (Objects.equals(this.monoLevel, value)) {
            return this;
        }
        return new KaraokeFilter(this.level, value, this.filterBand, this.filterWidth);
    }

    public final KaraokeFilter withFilterBand(@Nullable Float value) {
        if (Objects.equals(this.filterBand, value)) {
            return this;
        }
        return new KaraokeFilter(this.level, this.monoLevel, value, this.filterWidth);
    }

    public final KaraokeFilter withFilterWidth(@Nullable Float value) {
        if (Objects.equals(this.filterWidth, value)) {
            return this;
        }
        return new KaraokeFilter(this.level, this.monoLevel, this.filterBand, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof KaraokeFilter && this.equalTo((KaraokeFilter)another);
    }

    private boolean equalTo(KaraokeFilter another) {
        return Objects.equals(this.level, another.level) && Objects.equals(this.monoLevel, another.monoLevel) && Objects.equals(this.filterBand, another.filterBand) && Objects.equals(this.filterWidth, another.filterWidth);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.level);
        h += (h << 5) + Objects.hashCode(this.monoLevel);
        h += (h << 5) + Objects.hashCode(this.filterBand);
        h += (h << 5) + Objects.hashCode(this.filterWidth);
        return h;
    }

    public String toString() {
        return "Karaoke{level=" + this.level + ", monoLevel=" + this.monoLevel + ", filterBand=" + this.filterBand + ", filterWidth=" + this.filterWidth + "}";
    }

    public static KaraokeFilter of(@Nullable Float level, @Nullable Float monoLevel, @Nullable Float filterBand, @Nullable Float filterWidth) {
        return new KaraokeFilter(level, monoLevel, filterBand, filterWidth);
    }

    public static KaraokeFilter copyOf(DefaultFilters.Karaoke instance) {
        if (instance instanceof KaraokeFilter) {
            return (KaraokeFilter)instance;
        }
        return KaraokeFilter.builder().from(instance).create();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="pw.aru.libs.andeclient.entities.player.DefaultFilters.Karaoke", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_LEVEL = 1L;
        private static final long OPT_BIT_MONO_LEVEL = 2L;
        private static final long OPT_BIT_FILTER_BAND = 4L;
        private static final long OPT_BIT_FILTER_WIDTH = 8L;
        private long optBits;
        @Nullable
        private Float level;
        @Nullable
        private Float monoLevel;
        @Nullable
        private Float filterBand;
        @Nullable
        private Float filterWidth;

        private Builder() {
        }

        public final Builder from(DefaultFilters.Karaoke instance) {
            Float filterWidthValue;
            Float filterBandValue;
            Float monoLevelValue;
            Objects.requireNonNull(instance, "instance");
            Float levelValue = instance.level();
            if (levelValue != null) {
                this.level(levelValue);
            }
            if ((monoLevelValue = instance.monoLevel()) != null) {
                this.monoLevel(monoLevelValue);
            }
            if ((filterBandValue = instance.filterBand()) != null) {
                this.filterBand(filterBandValue);
            }
            if ((filterWidthValue = instance.filterWidth()) != null) {
                this.filterWidth(filterWidthValue);
            }
            return this;
        }

        public final Builder level(@Nullable Float level) {
            this.level = level;
            this.optBits |= 1L;
            return this;
        }

        public final Builder monoLevel(@Nullable Float monoLevel) {
            this.monoLevel = monoLevel;
            this.optBits |= 2L;
            return this;
        }

        public final Builder filterBand(@Nullable Float filterBand) {
            this.filterBand = filterBand;
            this.optBits |= 4L;
            return this;
        }

        public final Builder filterWidth(@Nullable Float filterWidth) {
            this.filterWidth = filterWidth;
            this.optBits |= 8L;
            return this;
        }

        public KaraokeFilter create() {
            return new KaraokeFilter(this);
        }

        private boolean levelIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean monoLevelIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean filterBandIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean filterWidthIsSet() {
            return (this.optBits & 8L) != 0L;
        }
    }

    @Generated(from="pw.aru.libs.andeclient.entities.player.DefaultFilters.Karaoke", generator="Immutables")
    private final class InitShim {
        private byte levelBuildStage = 0;
        private Float level;
        private byte monoLevelBuildStage = 0;
        private Float monoLevel;
        private byte filterBandBuildStage = 0;
        private Float filterBand;
        private byte filterWidthBuildStage = 0;
        private Float filterWidth;

        private InitShim() {
        }

        Float level() {
            if (this.levelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.levelBuildStage == 0) {
                this.levelBuildStage = (byte)-1;
                this.level = KaraokeFilter.super.level();
                this.levelBuildStage = 1;
            }
            return this.level;
        }

        void level(Float level) {
            this.level = level;
            this.levelBuildStage = 1;
        }

        Float monoLevel() {
            if (this.monoLevelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.monoLevelBuildStage == 0) {
                this.monoLevelBuildStage = (byte)-1;
                this.monoLevel = KaraokeFilter.super.monoLevel();
                this.monoLevelBuildStage = 1;
            }
            return this.monoLevel;
        }

        void monoLevel(Float monoLevel) {
            this.monoLevel = monoLevel;
            this.monoLevelBuildStage = 1;
        }

        Float filterBand() {
            if (this.filterBandBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filterBandBuildStage == 0) {
                this.filterBandBuildStage = (byte)-1;
                this.filterBand = KaraokeFilter.super.filterBand();
                this.filterBandBuildStage = 1;
            }
            return this.filterBand;
        }

        void filterBand(Float filterBand) {
            this.filterBand = filterBand;
            this.filterBandBuildStage = 1;
        }

        Float filterWidth() {
            if (this.filterWidthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filterWidthBuildStage == 0) {
                this.filterWidthBuildStage = (byte)-1;
                this.filterWidth = KaraokeFilter.super.filterWidth();
                this.filterWidthBuildStage = 1;
            }
            return this.filterWidth;
        }

        void filterWidth(Float filterWidth) {
            this.filterWidth = filterWidth;
            this.filterWidthBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.levelBuildStage == -1) {
                attributes.add("level");
            }
            if (this.monoLevelBuildStage == -1) {
                attributes.add("monoLevel");
            }
            if (this.filterBandBuildStage == -1) {
                attributes.add("filterBand");
            }
            if (this.filterWidthBuildStage == -1) {
                attributes.add("filterWidth");
            }
            return "Cannot build Karaoke, attribute initializers form cycle " + attributes;
        }
    }
}

