/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.util;

import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pw.aru.libs.andeclient.entities.AndesiteNode;
import pw.aru.libs.andeclient.entities.AudioLoadResult;
import pw.aru.libs.andeclient.entities.internal.ActualFailed;
import pw.aru.libs.andeclient.entities.internal.ActualInfo;
import pw.aru.libs.andeclient.entities.internal.ActualPlaylist;
import pw.aru.libs.andeclient.entities.internal.ActualStats;
import pw.aru.libs.andeclient.entities.internal.ActualTrack;
import pw.aru.libs.andeclient.entities.player.DefaultFilters;
import pw.aru.libs.andeclient.entities.player.PlayerFilter;
import pw.aru.libs.andeclient.util.AudioTrackUtil;

public class AndesiteUtil {
    private static final Logger logger = LoggerFactory.getLogger(AndesiteUtil.class);

    public static AndesiteNode.Info nodeInfo(JSONObject json) {
        return ActualInfo.builder().version(json.getString("version")).versionMajor(json.getString("versionMajor")).versionMinor(json.getString("versionMinor")).versionRevision(json.getString("versionRevision")).versionCommit(json.getString("versionCommit")).versionBuild(json.getLong("versionBuild")).nodeRegion(json.getString("nodeRegion")).nodeId(json.getString("nodeId")).enabledSources(AndesiteUtil.toStringList(json.getJSONArray("enabledSources"))).loadedPlugins(AndesiteUtil.toStringList(json.getJSONArray("loadedPlugins"))).build();
    }

    public static AndesiteNode.Stats nodeStats(JSONObject json) {
        JSONObject jsonPlayers = json.getJSONObject("players");
        JSONObject jsonCpu = json.optJSONObject("cpu");
        JSONObject jsonFrames = json.optJSONObject("frameStats");
        return ActualStats.builder().players(jsonPlayers.getInt("total")).playingPlayers(jsonPlayers.getInt("playing")).uptime(json.getJSONObject("runtime").getLong("uptime")).systemLoad(jsonCpu == null ? 0.0 : jsonCpu.getDouble("system")).andesiteLoad(jsonCpu == null ? 0.0 : jsonCpu.getDouble("andesite")).sentFrames(jsonFrames.optLong("sent", 0L)).nulledFrames(jsonFrames.optLong("nulled", 0L)).deficitFrames(jsonFrames.optLong("deficit", 0L)).build();
    }

    public static AudioLoadResult audioLoadResult(JSONObject json) {
        switch (json.getString("loadType")) {
            case "TRACK_LOADED": {
                return ActualTrack.builder().track(AudioTrackUtil.fromString(json.getJSONArray("tracks").getJSONObject(0).getString("track"))).build();
            }
            case "PLAYLIST_LOADED": 
            case "SEARCH_RESULTS": {
                List tracks = StreamSupport.stream(json.getJSONArray("tracks").spliterator(), false).filter(track -> track instanceof JSONObject).map(track -> (JSONObject)track).map(jsonTrack -> AudioTrackUtil.fromString(jsonTrack.getString("track"))).collect(Collectors.toUnmodifiableList());
                JSONObject info = json.getJSONObject("playlistInfo");
                String name = info.getString("name");
                int selected = info.optInt("selectedTrack", -1);
                return ActualPlaylist.builder().searchResults(json.getString("loadType").equals("SEARCH_RESULTS")).tracks(tracks).playlistName(name).selectedIndex(selected).selectedTrack(selected < 0 ? null : (AudioTrack)tracks.get(selected)).build();
            }
            case "LOAD_FAILED": {
                return ActualFailed.builder().cause(json.getJSONObject("cause").getString("message")).severity(FriendlyException.Severity.valueOf((String)json.getString("severity"))).build();
            }
            case "NO_MATCHES": {
                return AudioLoadResult.NO_MATCHES;
            }
        }
        logger.warn("unknown loadType {} | raw json is {}", (Object)json.getString("loadType"), (Object)json);
        return AudioLoadResult.UNKNOWN;
    }

    private static List<String> toStringList(JSONArray array) {
        return StreamSupport.stream(array.spliterator(), false).map(Object::toString).collect(Collectors.toUnmodifiableList());
    }

    public static Set<PlayerFilter> playerFilters(JSONObject jsonFilters) {
        ArrayList<PlayerFilter> filters = new ArrayList<PlayerFilter>();
        block16: for (String filter : jsonFilters.keySet()) {
            JSONObject jsonFilter = jsonFilters.getJSONObject(filter);
            if (!jsonFilter.getBoolean("enabled")) continue;
            switch (filter) {
                case "equalizer": {
                    DefaultFilters.Equalizer equalizer = DefaultFilters.equalizer();
                    JSONArray bands = jsonFilter.getJSONArray("bands");
                    for (int band = 0; band < bands.length(); ++band) {
                        float gain = bands.getFloat(band);
                        if (gain == 0.0f) continue;
                        equalizer.withBand(band, Float.valueOf(gain));
                    }
                    filters.add(equalizer);
                    continue block16;
                }
                case "karaoke": {
                    filters.add(DefaultFilters.karaoke().level(Float.valueOf(jsonFilter.getFloat("level"))).monoLevel(Float.valueOf(jsonFilter.getFloat("monoLevel"))).filterBand(Float.valueOf(jsonFilter.getFloat("filterBand"))).filterWidth(Float.valueOf(jsonFilter.getFloat("filterWidth"))).create());
                    continue block16;
                }
                case "timescale": {
                    filters.add(DefaultFilters.timescale().speed(Float.valueOf(jsonFilter.getFloat("speed"))).pitch(Float.valueOf(jsonFilter.getFloat("pitch"))).rate(Float.valueOf(jsonFilter.getFloat("rate"))).create());
                    continue block16;
                }
                case "tremolo": {
                    filters.add(DefaultFilters.tremolo().frequency(Float.valueOf(jsonFilter.getFloat("frequency"))).depth(Float.valueOf(jsonFilter.getFloat("depth"))).create());
                    continue block16;
                }
                case "vibrato": {
                    filters.add(DefaultFilters.vibrato().frequency(Float.valueOf(jsonFilter.getFloat("frequency"))).depth(Float.valueOf(jsonFilter.getFloat("depth"))).create());
                    continue block16;
                }
                case "volume": {
                    filters.add(DefaultFilters.volume(Float.valueOf(jsonFilter.getFloat("volume"))));
                    continue block16;
                }
            }
            filters.add(new PlayerFilter.Raw(filter, jsonFilter));
        }
        return Set.copyOf(filters);
    }
}

