/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.events.player.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pw.aru.libs.andeclient.entities.AndePlayer;
import pw.aru.libs.andeclient.entities.player.PlayerFilter;
import pw.aru.libs.andeclient.events.AndePlayerEvent;
import pw.aru.libs.andeclient.events.player.PlayerUpdateEvent;

@ParametersAreNonnullByDefault
@Generated(from="pw.aru.libs.andeclient.events.player.PlayerUpdateEvent", generator="Immutables")
@Immutable
public final class PostedPlayerUpdateEvent
extends PlayerUpdateEvent {
    private final AndePlayer player;
    private final long timestamp;
    private final long position;
    private final int volume;
    private final Collection<? extends PlayerFilter> filters;
    private final long oldTimestamp;
    private final long oldPosition;

    private PostedPlayerUpdateEvent(Builder builder) {
        this.player = builder.player;
        this.timestamp = builder.timestamp;
        this.position = builder.position;
        this.volume = builder.volume;
        this.filters = builder.filters;
        this.oldTimestamp = builder.oldTimestamp;
        this.oldPosition = builder.oldPosition;
    }

    @Override
    public AndePlayer player() {
        return this.player;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public int volume() {
        return this.volume;
    }

    @Override
    public Collection<? extends PlayerFilter> filters() {
        return this.filters;
    }

    @Override
    public long oldTimestamp() {
        return this.oldTimestamp;
    }

    @Override
    public long oldPosition() {
        return this.oldPosition;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PostedPlayerUpdateEvent && this.equalTo((PostedPlayerUpdateEvent)another);
    }

    private boolean equalTo(PostedPlayerUpdateEvent another) {
        return this.player.equals(another.player) && this.timestamp == another.timestamp && this.position == another.position && this.volume == another.volume && this.filters.equals(another.filters) && this.oldTimestamp == another.oldTimestamp && this.oldPosition == another.oldPosition;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.player.hashCode();
        h += (h << 5) + Long.hashCode(this.timestamp);
        h += (h << 5) + Long.hashCode(this.position);
        h += (h << 5) + this.volume;
        h += (h << 5) + this.filters.hashCode();
        h += (h << 5) + Long.hashCode(this.oldTimestamp);
        h += (h << 5) + Long.hashCode(this.oldPosition);
        return h;
    }

    public String toString() {
        return "PlayerUpdateEvent{player=" + this.player + ", timestamp=" + this.timestamp + ", position=" + this.position + ", volume=" + this.volume + ", filters=" + this.filters + ", oldTimestamp=" + this.oldTimestamp + ", oldPosition=" + this.oldPosition + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="pw.aru.libs.andeclient.events.player.PlayerUpdateEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PLAYER = 1L;
        private static final long INIT_BIT_TIMESTAMP = 2L;
        private static final long INIT_BIT_POSITION = 4L;
        private static final long INIT_BIT_VOLUME = 8L;
        private static final long INIT_BIT_FILTERS = 16L;
        private static final long INIT_BIT_OLD_TIMESTAMP = 32L;
        private static final long INIT_BIT_OLD_POSITION = 64L;
        private long initBits = 127L;
        @Nullable
        private AndePlayer player;
        private long timestamp;
        private long position;
        private int volume;
        @Nullable
        private Collection<? extends PlayerFilter> filters;
        private long oldTimestamp;
        private long oldPosition;

        private Builder() {
        }

        public final Builder from(AndePlayerEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PlayerUpdateEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AndePlayerEvent instance;
            long bits = 0L;
            if (object instanceof AndePlayerEvent) {
                instance = (AndePlayerEvent)object;
                if ((bits & 1L) == 0L) {
                    this.player(instance.player());
                    bits |= 1L;
                }
            }
            if (object instanceof PlayerUpdateEvent) {
                instance = (PlayerUpdateEvent)object;
                this.volume(((PlayerUpdateEvent)instance).volume());
                this.oldTimestamp(((PlayerUpdateEvent)instance).oldTimestamp());
                this.position(((PlayerUpdateEvent)instance).position());
                this.filters(((PlayerUpdateEvent)instance).filters());
                this.oldPosition(((PlayerUpdateEvent)instance).oldPosition());
                if ((bits & 1L) == 0L) {
                    this.player(((PlayerUpdateEvent)instance).player());
                    bits |= 1L;
                }
                this.timestamp(((PlayerUpdateEvent)instance).timestamp());
            }
        }

        public final Builder player(AndePlayer player) {
            this.player = Objects.requireNonNull(player, "player");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder position(long position) {
            this.position = position;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder volume(int volume) {
            this.volume = volume;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder filters(Collection<? extends PlayerFilter> filters) {
            this.filters = Objects.requireNonNull(filters, "filters");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder oldTimestamp(long oldTimestamp) {
            this.oldTimestamp = oldTimestamp;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder oldPosition(long oldPosition) {
            this.oldPosition = oldPosition;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public PostedPlayerUpdateEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new PostedPlayerUpdateEvent(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("player");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("timestamp");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("position");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("volume");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("filters");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("oldTimestamp");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("oldPosition");
            }
            return "Cannot build PlayerUpdateEvent, some of required attributes are not set " + attributes;
        }
    }
}

