/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.internal;

import pw.aru.libs.andeclient.entities.AndesiteNode;
import pw.aru.libs.andeclient.entities.LoadBalancer;

public class DefaultLoadBalancer
implements LoadBalancer {
    public static final LoadBalancer INSTANCE = new DefaultLoadBalancer();

    private DefaultLoadBalancer() {
    }

    @Override
    public int playerPenalty(AndesiteNode.Stats stats) {
        return stats.playingPlayers();
    }

    @Override
    public int cpuPenalty(AndesiteNode.Stats stats) {
        return (int)Math.pow(1.05, 100.0 * stats.systemLoad()) * 10 - 10;
    }

    @Override
    public int deficitFramePenalty(AndesiteNode.Stats stats) {
        return (int)(Math.pow(1.03, 500.0f * ((float)stats.deficitFrames() / 3000.0f)) * 600.0 - 600.0);
    }

    @Override
    public int nullFramePenalty(AndesiteNode.Stats stats) {
        return (int)(Math.pow(1.03, 500.0f * ((float)stats.nulledFrames() / 3000.0f)) * 300.0 - 300.0) * 2;
    }
}

