/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.entities.configurator.internal;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pw.aru.libs.andeclient.entities.AndeClient;
import pw.aru.libs.andeclient.entities.configurator.AndesiteNodeConfigurator;

@ParametersAreNonnullByDefault
@Generated(from="pw.aru.libs.andeclient.entities.configurator.AndesiteNodeConfigurator", generator="Modifiables")
@NotThreadSafe
public class ActualAndesiteNodeConfigurator
extends AndesiteNodeConfigurator {
    private static final long INIT_BIT_CLIENT = 1L;
    private static final long OPT_BIT_HOST = 1L;
    private static final long OPT_BIT_PORT = 2L;
    private static final long OPT_BIT_PASSWORD = 4L;
    private long initBits = 1L;
    private long optBits;
    private AndeClient client;
    @Nullable
    private String host;
    private int port;
    @Nullable
    private String password;
    private String relativePath;

    @Override
    public final AndeClient client() {
        if (!this.clientIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.client;
    }

    @Override
    @Nullable
    public final String host() {
        return this.hostIsSet() ? this.host : super.host();
    }

    @Override
    public final int port() {
        return this.portIsSet() ? this.port : super.port();
    }

    @Override
    @Nullable
    public final String password() {
        return this.passwordIsSet() ? this.password : super.password();
    }

    @Override
    public final String relativePath() {
        return this.relativePathIsSet() ? this.relativePath : super.relativePath();
    }

    public ActualAndesiteNodeConfigurator clear() {
        this.initBits = 1L;
        this.optBits = 0L;
        this.client = null;
        this.host = null;
        this.port = 0;
        this.password = null;
        this.relativePath = null;
        return this;
    }

    public ActualAndesiteNodeConfigurator from(AndesiteNodeConfigurator instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ActualAndesiteNodeConfigurator) {
            this.from((ActualAndesiteNodeConfigurator)instance);
            return this;
        }
        this.client(instance.client());
        String hostValue = instance.host();
        if (hostValue != null) {
            this.host(hostValue);
        }
        this.port(instance.port());
        String passwordValue = instance.password();
        if (passwordValue != null) {
            this.password(passwordValue);
        }
        this.relativePath(instance.relativePath());
        return this;
    }

    public ActualAndesiteNodeConfigurator from(ActualAndesiteNodeConfigurator instance) {
        String hostValue;
        Objects.requireNonNull(instance, "instance");
        if (instance.clientIsSet()) {
            this.client(instance.client());
        }
        if ((hostValue = instance.host()) != null) {
            this.host(hostValue);
        }
        this.port(instance.port());
        String passwordValue = instance.password();
        if (passwordValue != null) {
            this.password(passwordValue);
        }
        this.relativePath(instance.relativePath());
        return this;
    }

    public ActualAndesiteNodeConfigurator client(AndeClient client) {
        this.client = Objects.requireNonNull(client, "client");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public ActualAndesiteNodeConfigurator host(@Nullable String host) {
        this.host = host;
        this.optBits |= 1L;
        return this;
    }

    public ActualAndesiteNodeConfigurator port(int port) {
        this.port = port;
        this.optBits |= 2L;
        return this;
    }

    public ActualAndesiteNodeConfigurator password(@Nullable String password) {
        this.password = password;
        this.optBits |= 4L;
        return this;
    }

    public ActualAndesiteNodeConfigurator relativePath(String relativePath) {
        this.relativePath = Objects.requireNonNull(relativePath, "relativePath");
        return this;
    }

    public final boolean clientIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    public final boolean hostIsSet() {
        return (this.optBits & 1L) != 0L;
    }

    public final boolean portIsSet() {
        return (this.optBits & 2L) != 0L;
    }

    public final boolean passwordIsSet() {
        return (this.optBits & 4L) != 0L;
    }

    public final boolean relativePathIsSet() {
        return this.relativePath != null;
    }

    public final ActualAndesiteNodeConfigurator unsetClient() {
        this.initBits |= 1L;
        this.client = null;
        return this;
    }

    public final ActualAndesiteNodeConfigurator unsetHost() {
        this.optBits |= 0L;
        this.host = null;
        return this;
    }

    public final ActualAndesiteNodeConfigurator unsetPort() {
        this.optBits |= 0L;
        this.port = 0;
        return this;
    }

    public final ActualAndesiteNodeConfigurator unsetPassword() {
        this.optBits |= 0L;
        this.password = null;
        return this;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.clientIsSet()) {
            attributes.add("client");
        }
        return "AndesiteNodeConfigurator is not initialized, some of the required attributes are not set " + attributes;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ActualAndesiteNodeConfigurator)) {
            return false;
        }
        ActualAndesiteNodeConfigurator other = (ActualAndesiteNodeConfigurator)another;
        if (!this.isInitialized() || !other.isInitialized()) {
            return false;
        }
        return this.equalTo(other);
    }

    private boolean equalTo(ActualAndesiteNodeConfigurator another) {
        String host = this.host();
        int port = this.port();
        String password = this.password();
        String relativePath = this.relativePath();
        return this.client.equals(another.client) && Objects.equals(host, another.host()) && port == another.port() && Objects.equals(password, another.password()) && relativePath.equals(another.relativePath());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.client.hashCode();
        String host = this.host();
        h += (h << 5) + Objects.hashCode(host);
        int port = this.port();
        h += (h << 5) + port;
        String password = this.password();
        h += (h << 5) + Objects.hashCode(password);
        String relativePath = this.relativePath();
        h += (h << 5) + relativePath.hashCode();
        return h;
    }

    public String toString() {
        return "ActualAndesiteNodeConfigurator{client=" + (this.clientIsSet() ? this.client() : "?") + ", host=" + this.host() + ", port=" + this.port() + ", password=" + this.password() + ", relativePath=" + this.relativePath() + "}";
    }
}

