/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.internal;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pw.aru.lib.eventpipes.api.EventConsumer;
import pw.aru.lib.eventpipes.api.EventSubscription;
import pw.aru.libs.andeclient.entities.AndeClient;
import pw.aru.libs.andeclient.entities.AndesiteNode;
import pw.aru.libs.andeclient.entities.AudioLoadResult;
import pw.aru.libs.andeclient.entities.EntityState;
import pw.aru.libs.andeclient.entities.configurator.AndesiteNodeConfigurator;
import pw.aru.libs.andeclient.events.AndeClientEvent;
import pw.aru.libs.andeclient.events.AndesiteNodeEvent;
import pw.aru.libs.andeclient.events.node.internal.PostedNewNodeEvent;
import pw.aru.libs.andeclient.events.node.internal.PostedNodeConnectedEvent;
import pw.aru.libs.andeclient.events.node.internal.PostedNodeRemovedEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedPlayerRemovedEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedWebSocketClosedEvent;
import pw.aru.libs.andeclient.events.track.internal.PostedTrackEndEvent;
import pw.aru.libs.andeclient.events.track.internal.PostedTrackExceptionEvent;
import pw.aru.libs.andeclient.events.track.internal.PostedTrackStartEvent;
import pw.aru.libs.andeclient.events.track.internal.PostedTrackStuckEvent;
import pw.aru.libs.andeclient.exceptions.RemoteTrackException;
import pw.aru.libs.andeclient.internal.AndeClientImpl;
import pw.aru.libs.andeclient.internal.AndePlayerImpl;
import pw.aru.libs.andeclient.util.AndesiteUtil;
import pw.aru.libs.andeclient.util.AudioTrackUtil;

public class AndesiteNodeImpl
implements AndesiteNode,
WebSocket.Listener {
    private static final Logger logger = LoggerFactory.getLogger(AndesiteNodeImpl.class);
    private final AndeClientImpl client;
    final Map<Long, AndePlayerImpl> children = new ConcurrentHashMap<Long, AndePlayerImpl>();
    private WebSocket websocket;
    private final String host;
    private final int port;
    private final String password;
    private final String relativePath;
    private final Queue<JSONObject> outgoingQueue = new LinkedBlockingQueue<JSONObject>();
    private AndesiteNode.Info info;
    private final Queue<CompletableFuture<AndesiteNode.Stats>> awaitingStats = new LinkedBlockingQueue<CompletableFuture<AndesiteNode.Stats>>();
    private final StringBuilder wsBuffer = new StringBuilder();
    private EntityState state = EntityState.CONFIGURING;
    private ByteBuffer pingBuffer = ByteBuffer.allocate(4);
    private ScheduledFuture<?> scheduledPing;

    public AndesiteNodeImpl(AndesiteNodeConfigurator configurator) {
        this.client = (AndeClientImpl)configurator.client();
        this.host = configurator.host();
        this.port = configurator.port();
        this.password = configurator.password();
        this.relativePath = configurator.relativePath();
        this.client.nodes.add(this);
        this.client.events.publish((Object)PostedNewNodeEvent.of(this));
        this.initWS();
    }

    @Override
    @Nonnull
    public AndeClient client() {
        return this.client;
    }

    @Override
    @Nonnull
    public EntityState state() {
        return this.state;
    }

    @Override
    @Nonnull
    public String host() {
        return this.host;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public String relativePath() {
        return this.relativePath;
    }

    @Override
    @Nonnull
    public AndesiteNode.Info nodeInfo() {
        return this.info;
    }

    @Override
    public void destroy() {
        if (this.state == EntityState.DESTROYED) {
            return;
        }
        if (this.websocket == null) {
            throw new IllegalStateException("AndesiteNode's websocket is null, it is either already closed or trying to connect to the node.");
        }
        logger.trace("received destroy call, destroying websocket and cleaning up...");
        this.websocket.sendClose(1000, "Client shutting down").thenRun(this::exitCleanup);
    }

    @Override
    @Nonnull
    public CompletionStage<AndesiteNode.Stats> stats() {
        if (this.state == EntityState.DESTROYED) {
            throw new IllegalStateException("Destroyed AndesiteNode.");
        }
        CompletableFuture<AndesiteNode.Stats> stats = new CompletableFuture<AndesiteNode.Stats>();
        this.awaitingStats.add(stats);
        this.handleOutgoing(new JSONObject().put("op", (Object)"get-stats"));
        return stats;
    }

    @Override
    @Nonnull
    public CompletionStage<AudioLoadResult> loadTracksAsync(String identifier) {
        URI uri = URI.create(String.format("http://%s:%d/%s?identifier=%s", this.host, this.port, this.relativePath != null ? this.relativePath + "/loadtracks" : "loadtracks", URLEncoder.encode(identifier, StandardCharsets.UTF_8)));
        HttpRequest.Builder builder = HttpRequest.newBuilder().GET().uri(uri);
        if (this.password != null) {
            builder.header("Authorization", this.password);
        }
        return this.client.httpClient.sendAsync(builder.build(), HttpResponse.BodyHandlers.ofString()).thenApply(it -> AndesiteUtil.audioLoadResult(new JSONObject((String)it.body())));
    }

    @Override
    public EventSubscription<AndeClientEvent> on(EventConsumer<AndesiteNodeEvent> consumer) {
        return this.client.on((EventConsumer<AndeClientEvent>)((EventConsumer)event -> {
            if (event instanceof AndesiteNodeEvent && ((AndesiteNodeEvent)event).node() == this) {
                consumer.onEvent((Object)((AndesiteNodeEvent)event));
            }
        }));
    }

    void handleOutgoing(JSONObject json) {
        if (this.state == EntityState.DESTROYED) {
            return;
        }
        if (this.websocket == null) {
            this.outgoingQueue.offer(json);
            logger.trace("queued outgoing json to send after websocket init | json is {}", (Object)json);
            return;
        }
        logger.trace("sending outgoing json to andesite | json is {}", (Object)json);
        this.websocket.sendText(json.toString(), true);
    }

    private void handleIncoming(JSONObject json) {
        logger.trace("received incoming json from andesite | json is {}", (Object)json);
        try {
            switch (json.getString("op")) {
                case "connection-id": {
                    logger.trace("received connection-id from andesite, ignoring value");
                    return;
                }
                case "metadata": {
                    logger.trace("received metadata from andesite, updating info");
                    this.info = AndesiteUtil.nodeInfo(json.getJSONObject("data"));
                    return;
                }
                case "event": {
                    switch (json.getString("type")) {
                        case "TrackStartEvent": {
                            AudioTrack track;
                            logger.trace("received event TrackStartEvent, publishing it");
                            AndePlayerImpl player = this.playerFromEvent(json);
                            if (player == null) {
                                logger.trace("player not on AndeClient, dropping update");
                                return;
                            }
                            player.playingTrack = track = AudioTrackUtil.fromString(json.getString("track"));
                            this.client.events.publish((Object)PostedTrackStartEvent.builder().player(player).track(track).build());
                            return;
                        }
                        case "TrackEndEvent": {
                            logger.trace("received event TrackEndEvent, publishing it");
                            AndePlayerImpl player = this.playerFromEvent(json);
                            if (player == null) {
                                logger.trace("player not on AndeClient, dropping update");
                                return;
                            }
                            AudioTrack track = AudioTrackUtil.fromString(json.getString("track"));
                            player.playingTrack = null;
                            this.client.events.publish((Object)PostedTrackEndEvent.builder().player(player).track(track).reason(AudioTrackEndReason.valueOf((String)json.getString("reason"))).build());
                            return;
                        }
                        case "TrackExceptionEvent": {
                            logger.trace("received event TrackExceptionEvent, publishing it");
                            AndePlayerImpl player = this.playerFromEvent(json);
                            if (player == null) {
                                logger.trace("player not on AndeClient, dropping update");
                                return;
                            }
                            AudioTrack track = AudioTrackUtil.fromString(json.getString("track"));
                            this.client.events.publish((Object)PostedTrackExceptionEvent.builder().player(player).track(track).exception(new RemoteTrackException(this.client, player, this, track, json.getString("error"))).build());
                            return;
                        }
                        case "TrackStuckEvent": {
                            logger.trace("received event TrackStuckEvent, publishing it");
                            AndePlayerImpl player = this.playerFromEvent(json);
                            if (player == null) {
                                logger.trace("player not on AndeClient, dropping update");
                                return;
                            }
                            AudioTrack track = AudioTrackUtil.fromString(json.getString("track"));
                            this.client.events.publish((Object)PostedTrackStuckEvent.builder().player(player).track(track).thresholdMs(json.getInt("thresholdMs")).build());
                            return;
                        }
                        case "WebSocketClosedEvent": {
                            logger.trace("received event WebSocketClosedEvent, publishing it");
                            AndePlayerImpl player = this.playerFromEvent(json);
                            if (player == null) {
                                logger.trace("player not on AndeClient, dropping event");
                                return;
                            }
                            player.playingTrack = null;
                            this.client.events.publish((Object)PostedWebSocketClosedEvent.builder().player(player).reason(json.getString("reason")).closeCode(json.getInt("code")).byRemote(json.getBoolean("byRemote")).build());
                            return;
                        }
                    }
                    logger.warn("received event of unknown type | raw json is {}", (Object)json);
                    return;
                }
                case "player-update": {
                    logger.trace("received player update, sending to player");
                    AndePlayerImpl player = this.playerFromEvent(json);
                    if (player == null) {
                        logger.trace("player not on AndeClient, dropping update");
                        return;
                    }
                    player.update(json.getJSONObject("state"));
                    return;
                }
                case "pong": {
                    logger.trace("received pong from andesite");
                    return;
                }
                case "stats": {
                    CompletableFuture<AndesiteNode.Stats> future;
                    logger.trace("received stats from andesite, publishing to futures");
                    AndesiteNode.Stats stats = AndesiteUtil.nodeStats(json.getJSONObject("stats"));
                    while (!this.awaitingStats.isEmpty() && (future = this.awaitingStats.poll()) != null) {
                        future.complete(stats);
                    }
                    return;
                }
            }
            logger.warn("Received unknown op | raw json is {}", (Object)json);
        }
        catch (Exception e) {
            logger.error("Errored while handling json " + json, (Throwable)e);
        }
    }

    private void initWS() {
        WebSocket.Builder builder = this.client.httpClient.newWebSocketBuilder().header("User-Id", String.valueOf(this.client.userId()));
        if (this.password != null) {
            builder.header("Authorization", this.password);
        }
        URI uri = URI.create(String.format("ws://%s:%d/%s", this.host, this.port, this.relativePath != null ? this.relativePath + "/websocket" : "websocket"));
        builder.buildAsync(uri, this);
    }

    @Override
    public void onOpen(WebSocket ws) {
        this.websocket = ws;
        logger.trace("websocket ws://{}:{}/{} opened", new Object[]{this.host, this.port, this.relativePath != null ? this.relativePath + "/websocket" : "websocket"});
        this.client.events.publish((Object)PostedNodeConnectedEvent.of(this));
        ws.request(1L);
        this.scheduledPing = this.client.executor.scheduleAtFixedRate(this::doPing, 10L, 10L, TimeUnit.SECONDS);
        this.state = EntityState.AVAILABLE;
        if (!this.outgoingQueue.isEmpty()) {
            logger.trace("sending all cached outgoing json after websocket opened");
            while (!this.outgoingQueue.isEmpty()) {
                this.handleOutgoing(this.outgoingQueue.poll());
            }
            logger.trace("cached json sent");
        }
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        logger.trace("received close from andesite, cleaning up");
        this.exitCleanup();
        return null;
    }

    private void doPing() {
        this.pingBuffer.asCharBuffer().position(0).append("poke").flip();
        this.websocket.sendPing(this.pingBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> onText(WebSocket ws, CharSequence data, boolean last) {
        this.wsBuffer.append(data);
        if (last) {
            try {
                JSONObject json = new JSONObject(this.wsBuffer.toString());
                this.handleIncoming(json);
            }
            catch (Exception e) {
                logger.error("Received payload that it's not valid json | raw is {}", (Object)this.wsBuffer.toString(), (Object)e);
            }
            finally {
                this.wsBuffer.setLength(0);
            }
        }
        ws.request(1L);
        return CompletableFuture.completedStage(data);
    }

    private void exitCleanup() {
        this.state = EntityState.DESTROYED;
        this.websocket = null;
        this.pingBuffer = null;
        this.awaitingStats.clear();
        this.wsBuffer.setLength(0);
        this.scheduledPing.cancel(true);
        this.client.nodes.remove(this);
        this.client.events.publish((Object)PostedNodeRemovedEvent.of(this));
        this.client.players.values().removeAll(this.children.values());
        for (AndePlayerImpl player : this.children.values()) {
            player.state = EntityState.DESTROYED;
            this.client.events.publish((Object)PostedPlayerRemovedEvent.of(player));
        }
        this.children.clear();
    }

    @Nullable
    private AndePlayerImpl playerFromEvent(@Nonnull JSONObject json) {
        return this.client.players.get(Long.parseLong(json.getString("guildId")));
    }

    public String toString() {
        return "AndesiteNode(" + String.format("%s:%d", this.host, this.port) + ")";
    }
}

