/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.entities.player.internal;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pw.aru.libs.andeclient.entities.player.PlayerFilter;

@ParametersAreNonnullByDefault
@Generated(from="pw.aru.libs.andeclient.entities.player.PlayerFilter.Vibrato", generator="Immutables")
@Immutable
public final class VibratoFilter
extends PlayerFilter.Vibrato {
    @Nullable
    private final Float frequency;
    @Nullable
    private final Float depth;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private VibratoFilter(Builder builder) {
        if (builder.frequencyIsSet()) {
            this.initShim.frequency(builder.frequency);
        }
        if (builder.depthIsSet()) {
            this.initShim.depth(builder.depth);
        }
        this.frequency = this.initShim.frequency();
        this.depth = this.initShim.depth();
        this.initShim = null;
    }

    private VibratoFilter(@Nullable Float frequency, @Nullable Float depth) {
        this.frequency = frequency;
        this.depth = depth;
        this.initShim = null;
    }

    @Override
    @Nullable
    public Float frequency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.frequency() : this.frequency;
    }

    @Override
    @Nullable
    public Float depth() {
        InitShim shim = this.initShim;
        return shim != null ? shim.depth() : this.depth;
    }

    public final VibratoFilter withFrequency(@Nullable Float value) {
        if (Objects.equals(this.frequency, value)) {
            return this;
        }
        return VibratoFilter.validate(new VibratoFilter(value, this.depth));
    }

    public final VibratoFilter withDepth(@Nullable Float value) {
        if (Objects.equals(this.depth, value)) {
            return this;
        }
        return VibratoFilter.validate(new VibratoFilter(this.frequency, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof VibratoFilter && this.equalTo((VibratoFilter)another);
    }

    private boolean equalTo(VibratoFilter another) {
        return Objects.equals(this.frequency, another.frequency) && Objects.equals(this.depth, another.depth);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.frequency);
        h += (h << 5) + Objects.hashCode(this.depth);
        return h;
    }

    public String toString() {
        return "Vibrato{frequency=" + this.frequency + ", depth=" + this.depth + "}";
    }

    public static VibratoFilter of(@Nullable Float frequency, @Nullable Float depth) {
        return VibratoFilter.validate(new VibratoFilter(frequency, depth));
    }

    private static VibratoFilter validate(VibratoFilter instance) {
        instance.check();
        return instance;
    }

    public static VibratoFilter copyOf(PlayerFilter.Vibrato instance) {
        if (instance instanceof VibratoFilter) {
            return (VibratoFilter)instance;
        }
        return VibratoFilter.builder().from(instance).create();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="pw.aru.libs.andeclient.entities.player.PlayerFilter.Vibrato", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_FREQUENCY = 1L;
        private static final long OPT_BIT_DEPTH = 2L;
        private long optBits;
        @Nullable
        private Float frequency;
        @Nullable
        private Float depth;

        private Builder() {
        }

        public final Builder from(PlayerFilter.Vibrato instance) {
            Float depthValue;
            Objects.requireNonNull(instance, "instance");
            Float frequencyValue = instance.frequency();
            if (frequencyValue != null) {
                this.frequency(frequencyValue);
            }
            if ((depthValue = instance.depth()) != null) {
                this.depth(depthValue);
            }
            return this;
        }

        public final Builder frequency(@Nullable Float frequency) {
            this.frequency = frequency;
            this.optBits |= 1L;
            return this;
        }

        public final Builder depth(@Nullable Float depth) {
            this.depth = depth;
            this.optBits |= 2L;
            return this;
        }

        public VibratoFilter create() {
            return VibratoFilter.validate(new VibratoFilter(this));
        }

        private boolean frequencyIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean depthIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Generated(from="pw.aru.libs.andeclient.entities.player.PlayerFilter.Vibrato", generator="Immutables")
    private final class InitShim {
        private byte frequencyBuildStage = 0;
        private Float frequency;
        private byte depthBuildStage = 0;
        private Float depth;

        private InitShim() {
        }

        Float frequency() {
            if (this.frequencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.frequencyBuildStage == 0) {
                this.frequencyBuildStage = (byte)-1;
                this.frequency = VibratoFilter.super.frequency();
                this.frequencyBuildStage = 1;
            }
            return this.frequency;
        }

        void frequency(Float frequency) {
            this.frequency = frequency;
            this.frequencyBuildStage = 1;
        }

        Float depth() {
            if (this.depthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.depthBuildStage == 0) {
                this.depthBuildStage = (byte)-1;
                this.depth = VibratoFilter.super.depth();
                this.depthBuildStage = 1;
            }
            return this.depth;
        }

        void depth(Float depth) {
            this.depth = depth;
            this.depthBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.frequencyBuildStage == -1) {
                attributes.add("frequency");
            }
            if (this.depthBuildStage == -1) {
                attributes.add("depth");
            }
            return "Cannot build Vibrato, attribute initializers form cycle " + attributes;
        }
    }
}

