/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.events.player.internal;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pw.aru.libs.andeclient.entities.AndePlayer;
import pw.aru.libs.andeclient.events.AndePlayerEvent;
import pw.aru.libs.andeclient.events.player.WebSocketClosedEvent;

@ParametersAreNonnullByDefault
@Generated(from="pw.aru.libs.andeclient.events.player.WebSocketClosedEvent", generator="Immutables")
@Immutable
public final class PostedWebSocketClosedEvent
extends WebSocketClosedEvent {
    private final AndePlayer player;
    private final String reason;
    private final boolean byRemote;
    private final int closeCode;

    private PostedWebSocketClosedEvent(Builder builder) {
        this.player = builder.player;
        this.reason = builder.reason;
        this.byRemote = builder.byRemote;
        this.closeCode = builder.closeCode;
    }

    @Override
    public AndePlayer player() {
        return this.player;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public boolean byRemote() {
        return this.byRemote;
    }

    @Override
    public int closeCode() {
        return this.closeCode;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof PostedWebSocketClosedEvent && this.equalTo((PostedWebSocketClosedEvent)another);
    }

    private boolean equalTo(PostedWebSocketClosedEvent another) {
        return this.player.equals(another.player) && this.reason.equals(another.reason) && this.byRemote == another.byRemote && this.closeCode == another.closeCode;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.player.hashCode();
        h += (h << 5) + this.reason.hashCode();
        h += (h << 5) + Boolean.hashCode(this.byRemote);
        h += (h << 5) + this.closeCode;
        return h;
    }

    public String toString() {
        return "WebSocketClosedEvent{player=" + this.player + ", reason=" + this.reason + ", byRemote=" + this.byRemote + ", closeCode=" + this.closeCode + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="pw.aru.libs.andeclient.events.player.WebSocketClosedEvent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PLAYER = 1L;
        private static final long INIT_BIT_REASON = 2L;
        private static final long INIT_BIT_BY_REMOTE = 4L;
        private static final long INIT_BIT_CLOSE_CODE = 8L;
        private long initBits = 15L;
        @Nullable
        private AndePlayer player;
        @Nullable
        private String reason;
        private boolean byRemote;
        private int closeCode;

        private Builder() {
        }

        public final Builder from(AndePlayerEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WebSocketClosedEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AndePlayerEvent instance;
            long bits = 0L;
            if (object instanceof AndePlayerEvent) {
                instance = (AndePlayerEvent)object;
                if ((bits & 1L) == 0L) {
                    this.player(instance.player());
                    bits |= 1L;
                }
            }
            if (object instanceof WebSocketClosedEvent) {
                instance = (WebSocketClosedEvent)object;
                this.byRemote(((WebSocketClosedEvent)instance).byRemote());
                this.reason(((WebSocketClosedEvent)instance).reason());
                this.closeCode(((WebSocketClosedEvent)instance).closeCode());
                if ((bits & 1L) == 0L) {
                    this.player(((WebSocketClosedEvent)instance).player());
                    bits |= 1L;
                }
            }
        }

        public final Builder player(AndePlayer player) {
            this.player = Objects.requireNonNull(player, "player");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder reason(String reason) {
            this.reason = Objects.requireNonNull(reason, "reason");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder byRemote(boolean byRemote) {
            this.byRemote = byRemote;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder closeCode(int closeCode) {
            this.closeCode = closeCode;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public PostedWebSocketClosedEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new PostedWebSocketClosedEvent(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("player");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("reason");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("byRemote");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("closeCode");
            }
            return "Cannot build WebSocketClosedEvent, some of required attributes are not set " + attributes;
        }
    }
}

