/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.entities.internal;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.json.JSONObject;
import pw.aru.libs.andeclient.entities.AndesiteNode;

@ParametersAreNonnullByDefault
@Generated(from="pw.aru.libs.andeclient.entities.AndesiteNode.Stats", generator="Immutables")
@Immutable
public final class ActualStats
implements AndesiteNode.Stats {
    private final AndesiteNode node;
    private final JSONObject raw;
    private final int players;
    private final int playingPlayers;
    private final long uptime;
    private final double systemLoad;
    private final double andesiteLoad;
    private final long sentFrames;
    private final long nulledFrames;
    private final long deficitFrames;

    private ActualStats(Builder builder) {
        this.node = builder.node;
        this.raw = builder.raw;
        this.players = builder.players;
        this.playingPlayers = builder.playingPlayers;
        this.uptime = builder.uptime;
        this.systemLoad = builder.systemLoad;
        this.andesiteLoad = builder.andesiteLoad;
        this.sentFrames = builder.sentFrames;
        this.nulledFrames = builder.nulledFrames;
        this.deficitFrames = builder.deficitFrames;
    }

    @Override
    public AndesiteNode node() {
        return this.node;
    }

    @Override
    public JSONObject raw() {
        return this.raw;
    }

    @Override
    public int players() {
        return this.players;
    }

    @Override
    public int playingPlayers() {
        return this.playingPlayers;
    }

    @Override
    public long uptime() {
        return this.uptime;
    }

    @Override
    public double systemLoad() {
        return this.systemLoad;
    }

    @Override
    public double andesiteLoad() {
        return this.andesiteLoad;
    }

    @Override
    public long sentFrames() {
        return this.sentFrames;
    }

    @Override
    public long nulledFrames() {
        return this.nulledFrames;
    }

    @Override
    public long deficitFrames() {
        return this.deficitFrames;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ActualStats && this.equalTo((ActualStats)another);
    }

    private boolean equalTo(ActualStats another) {
        return this.node.equals(another.node) && this.raw.equals(another.raw) && this.players == another.players && this.playingPlayers == another.playingPlayers && this.uptime == another.uptime && Double.doubleToLongBits(this.systemLoad) == Double.doubleToLongBits(another.systemLoad) && Double.doubleToLongBits(this.andesiteLoad) == Double.doubleToLongBits(another.andesiteLoad) && this.sentFrames == another.sentFrames && this.nulledFrames == another.nulledFrames && this.deficitFrames == another.deficitFrames;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.node.hashCode();
        h += (h << 5) + this.raw.hashCode();
        h += (h << 5) + this.players;
        h += (h << 5) + this.playingPlayers;
        h += (h << 5) + Long.hashCode(this.uptime);
        h += (h << 5) + Double.hashCode(this.systemLoad);
        h += (h << 5) + Double.hashCode(this.andesiteLoad);
        h += (h << 5) + Long.hashCode(this.sentFrames);
        h += (h << 5) + Long.hashCode(this.nulledFrames);
        h += (h << 5) + Long.hashCode(this.deficitFrames);
        return h;
    }

    public String toString() {
        return "Stats{node=" + this.node + ", raw=" + this.raw + ", players=" + this.players + ", playingPlayers=" + this.playingPlayers + ", uptime=" + this.uptime + ", systemLoad=" + this.systemLoad + ", andesiteLoad=" + this.andesiteLoad + ", sentFrames=" + this.sentFrames + ", nulledFrames=" + this.nulledFrames + ", deficitFrames=" + this.deficitFrames + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="pw.aru.libs.andeclient.entities.AndesiteNode.Stats", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NODE = 1L;
        private static final long INIT_BIT_RAW = 2L;
        private static final long INIT_BIT_PLAYERS = 4L;
        private static final long INIT_BIT_PLAYING_PLAYERS = 8L;
        private static final long INIT_BIT_UPTIME = 16L;
        private static final long INIT_BIT_SYSTEM_LOAD = 32L;
        private static final long INIT_BIT_ANDESITE_LOAD = 64L;
        private static final long INIT_BIT_SENT_FRAMES = 128L;
        private static final long INIT_BIT_NULLED_FRAMES = 256L;
        private static final long INIT_BIT_DEFICIT_FRAMES = 512L;
        private long initBits = 1023L;
        @Nullable
        private AndesiteNode node;
        @Nullable
        private JSONObject raw;
        private int players;
        private int playingPlayers;
        private long uptime;
        private double systemLoad;
        private double andesiteLoad;
        private long sentFrames;
        private long nulledFrames;
        private long deficitFrames;

        private Builder() {
        }

        public final Builder from(AndesiteNode.Stats instance) {
            Objects.requireNonNull(instance, "instance");
            this.node(instance.node());
            this.raw(instance.raw());
            this.players(instance.players());
            this.playingPlayers(instance.playingPlayers());
            this.uptime(instance.uptime());
            this.systemLoad(instance.systemLoad());
            this.andesiteLoad(instance.andesiteLoad());
            this.sentFrames(instance.sentFrames());
            this.nulledFrames(instance.nulledFrames());
            this.deficitFrames(instance.deficitFrames());
            return this;
        }

        public final Builder node(AndesiteNode node) {
            this.node = Objects.requireNonNull(node, "node");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder raw(JSONObject raw) {
            this.raw = Objects.requireNonNull(raw, "raw");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder players(int players) {
            this.players = players;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder playingPlayers(int playingPlayers) {
            this.playingPlayers = playingPlayers;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder uptime(long uptime) {
            this.uptime = uptime;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder systemLoad(double systemLoad) {
            this.systemLoad = systemLoad;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder andesiteLoad(double andesiteLoad) {
            this.andesiteLoad = andesiteLoad;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder sentFrames(long sentFrames) {
            this.sentFrames = sentFrames;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder nulledFrames(long nulledFrames) {
            this.nulledFrames = nulledFrames;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder deficitFrames(long deficitFrames) {
            this.deficitFrames = deficitFrames;
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public ActualStats build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ActualStats(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("node");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("raw");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("players");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("playingPlayers");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("uptime");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("systemLoad");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("andesiteLoad");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("sentFrames");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("nulledFrames");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("deficitFrames");
            }
            return "Cannot build Stats, some of required attributes are not set " + attributes;
        }
    }
}

