/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.util;

import com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.remote.RemoteNodeRegistry;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.ProbingAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.OrderedExecutor;
import com.sedmelluq.discord.lavaplayer.tools.io.MessageInput;
import com.sedmelluq.discord.lavaplayer.tools.io.MessageOutput;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DecodedTrackHolder;
import com.sedmelluq.lava.common.tools.ExecutorTools;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioTrackManager
implements AudioPlayerManager {
    private static final int TRACK_INFO_VERSIONED = 1;
    private static final int TRACK_INFO_VERSION = 2;
    private static final int MAXIMUM_LOAD_REDIRECTS = 5;
    private static final Logger log = LoggerFactory.getLogger(AudioTrackManager.class);
    private final List<AudioSourceManager> sourceManagers = new ArrayList<AudioSourceManager>();
    private final OrderedExecutor orderedForkJoinExecutor = new OrderedExecutor((ExecutorService)ForkJoinPool.commonPool());

    public void shutdown() {
        for (AudioSourceManager sourceManager : this.sourceManagers) {
            sourceManager.shutdown();
        }
    }

    public void registerSourceManager(AudioSourceManager sourceManager) {
        this.sourceManagers.add(sourceManager);
    }

    public <T extends AudioSourceManager> T source(Class<T> c) {
        for (AudioSourceManager sourceManager : this.sourceManagers) {
            if (!c.isAssignableFrom(sourceManager.getClass())) continue;
            return (T)((AudioSourceManager)c.cast(sourceManager));
        }
        return null;
    }

    public Future<Void> loadItem(String identifier, AudioLoadResultHandler resultHandler) {
        try {
            return ForkJoinPool.commonPool().submit(this.createItemLoader(identifier, resultHandler));
        }
        catch (RejectedExecutionException e) {
            return this.handleLoadRejected(identifier, resultHandler, e);
        }
    }

    public Future<Void> loadItemOrdered(Object orderingKey, String identifier, AudioLoadResultHandler resultHandler) {
        try {
            return this.orderedForkJoinExecutor.submit(orderingKey, this.createItemLoader(identifier, resultHandler));
        }
        catch (RejectedExecutionException e) {
            return this.handleLoadRejected(identifier, resultHandler, e);
        }
    }

    private Future<Void> handleLoadRejected(String identifier, AudioLoadResultHandler resultHandler, RejectedExecutionException e) {
        FriendlyException exception = new FriendlyException("Cannot queue loading a track, queue is full.", FriendlyException.Severity.SUSPICIOUS, (Throwable)e);
        ExceptionTools.log((Logger)log, (FriendlyException)exception, (Object)("queueing item " + identifier));
        resultHandler.loadFailed(exception);
        return ExecutorTools.COMPLETED_VOID;
    }

    private Callable<Void> createItemLoader(String identifier, AudioLoadResultHandler resultHandler) {
        return () -> {
            boolean[] reported = new boolean[1];
            try {
                if (!this.checkSourcesForItem(new AudioReference(identifier, null), resultHandler, reported)) {
                    log.debug("No matches for track with identifier {}.", (Object)identifier);
                    resultHandler.noMatches();
                }
            }
            catch (Throwable throwable) {
                if (reported[0]) {
                    log.warn("Load result handler for {} threw an exception", (Object)identifier, (Object)throwable);
                } else {
                    this.dispatchItemLoadFailure(identifier, resultHandler, throwable);
                }
                ExceptionTools.rethrowErrors((Throwable)throwable);
            }
            return null;
        };
    }

    private boolean checkSourcesForItem(AudioReference reference, AudioLoadResultHandler resultHandler, boolean[] reported) {
        AudioReference currentReference = reference;
        for (int redirects = 0; redirects < 5 && currentReference.identifier != null; ++redirects) {
            AudioItem item = this.checkSourcesForItemOnce(currentReference, resultHandler, reported);
            if (item == null) {
                return false;
            }
            if (!(item instanceof AudioReference)) {
                return true;
            }
            currentReference = (AudioReference)item;
        }
        return false;
    }

    private AudioItem checkSourcesForItemOnce(AudioReference reference, AudioLoadResultHandler resultHandler, boolean[] reported) {
        for (AudioSourceManager sourceManager : this.sourceManagers) {
            AudioItem item;
            if (reference.containerDescriptor != null && !(sourceManager instanceof ProbingAudioSourceManager) || (item = sourceManager.loadItem(null, reference)) == null) continue;
            if (item instanceof AudioTrack) {
                log.debug("Loaded a track with identifier {} using {}.", (Object)reference.identifier, (Object)sourceManager.getClass().getSimpleName());
                reported[0] = true;
                resultHandler.trackLoaded((AudioTrack)item);
            } else if (item instanceof AudioPlaylist) {
                log.debug("Loaded a playlist with identifier {} using {}.", (Object)reference.identifier, (Object)sourceManager.getClass().getSimpleName());
                reported[0] = true;
                resultHandler.playlistLoaded((AudioPlaylist)item);
            }
            return item;
        }
        return null;
    }

    private void dispatchItemLoadFailure(String identifier, AudioLoadResultHandler resultHandler, Throwable throwable) {
        FriendlyException exception = ExceptionTools.wrapUnfriendlyExceptions((String)"Something went wrong when looking up the track", (FriendlyException.Severity)FriendlyException.Severity.FAULT, (Throwable)throwable);
        ExceptionTools.log((Logger)log, (FriendlyException)exception, (Object)("loading item " + identifier));
        resultHandler.loadFailed(exception);
    }

    public void encodeTrack(MessageOutput stream, AudioTrack track) throws IOException {
        DataOutput output = stream.startMessage();
        output.write(2);
        AudioTrackInfo trackInfo = track.getInfo();
        output.writeUTF(trackInfo.title);
        output.writeUTF(trackInfo.author);
        output.writeLong(trackInfo.length);
        output.writeUTF(trackInfo.identifier);
        output.writeBoolean(trackInfo.isStream);
        DataFormatTools.writeNullableText((DataOutput)output, (String)trackInfo.uri);
        this.encodeTrackDetails(track, output);
        output.writeLong(track.getPosition());
        stream.commitMessage(1);
    }

    public DecodedTrackHolder decodeTrack(MessageInput stream) throws IOException {
        DataInput input = stream.nextMessage();
        if (input == null) {
            return null;
        }
        int version = (stream.getMessageFlags() & 1) != 0 ? input.readByte() & 0xFF : 1;
        AudioTrackInfo trackInfo = new AudioTrackInfo(input.readUTF(), input.readUTF(), input.readLong(), input.readUTF(), input.readBoolean(), version >= 2 ? DataFormatTools.readNullableText((DataInput)input) : null);
        AudioTrack track = this.decodeTrackDetails(trackInfo, input);
        long position = input.readLong();
        if (track != null) {
            track.setPosition(position);
        }
        stream.skipRemainingBytes();
        return new DecodedTrackHolder(track);
    }

    private void encodeTrackDetails(AudioTrack track, DataOutput output) throws IOException {
        AudioSourceManager sourceManager = track.getSourceManager();
        output.writeUTF(sourceManager.getSourceName());
        sourceManager.encodeTrack(track, output);
    }

    private AudioTrack decodeTrackDetails(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        String sourceName = input.readUTF();
        for (AudioSourceManager sourceManager : this.sourceManagers) {
            if (!sourceName.equals(sourceManager.getSourceName())) continue;
            return sourceManager.decodeTrack(trackInfo, input);
        }
        return null;
    }

    public void setHttpBuilderConfigurator(Consumer<HttpClientBuilder> ignored) {
        throw new UnsupportedOperationException();
    }

    public void setHttpRequestConfigurator(Function<RequestConfig, RequestConfig> ignored) {
        throw new UnsupportedOperationException();
    }

    public void setItemLoaderThreadPoolSize(int ignored) {
        throw new UnsupportedOperationException();
    }

    public void useRemoteNodes(String ... ignored) {
        throw new UnsupportedOperationException();
    }

    public void enableGcMonitoring() {
        throw new UnsupportedOperationException();
    }

    public AudioConfiguration getConfiguration() {
        throw new UnsupportedOperationException();
    }

    public boolean isUsingSeekGhosting() {
        throw new UnsupportedOperationException();
    }

    public void setUseSeekGhosting(boolean ignored) {
        throw new UnsupportedOperationException();
    }

    public int getFrameBufferDuration() {
        throw new UnsupportedOperationException();
    }

    public void setFrameBufferDuration(int ignored) {
        throw new UnsupportedOperationException();
    }

    public void setTrackStuckThreshold(long ignored) {
        throw new UnsupportedOperationException();
    }

    public void setPlayerCleanupThreshold(long ignored) {
        throw new UnsupportedOperationException();
    }

    public AudioPlayer createPlayer() {
        throw new UnsupportedOperationException();
    }

    public RemoteNodeRegistry getRemoteNodeRegistry() {
        throw new UnsupportedOperationException();
    }
}

