/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.entities.player.internal;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import pw.aru.libs.andeclient.entities.player.PlayerFilter;

@ParametersAreNonnullByDefault
@Generated(from="pw.aru.libs.andeclient.entities.player.PlayerFilter.Timescale", generator="Immutables")
@Immutable
public final class TimescaleFilter
extends PlayerFilter.Timescale {
    @Nullable
    private final Float speed;
    @Nullable
    private final Float pitch;
    @Nullable
    private final Float rate;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private TimescaleFilter(Builder builder) {
        if (builder.speedIsSet()) {
            this.initShim.speed(builder.speed);
        }
        if (builder.pitchIsSet()) {
            this.initShim.pitch(builder.pitch);
        }
        if (builder.rateIsSet()) {
            this.initShim.rate(builder.rate);
        }
        this.speed = this.initShim.speed();
        this.pitch = this.initShim.pitch();
        this.rate = this.initShim.rate();
        this.initShim = null;
    }

    private TimescaleFilter(@Nullable Float speed, @Nullable Float pitch, @Nullable Float rate) {
        this.speed = speed;
        this.pitch = pitch;
        this.rate = rate;
        this.initShim = null;
    }

    @Override
    @Nullable
    public Float speed() {
        InitShim shim = this.initShim;
        return shim != null ? shim.speed() : this.speed;
    }

    @Override
    @Nullable
    public Float pitch() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pitch() : this.pitch;
    }

    @Override
    @Nullable
    public Float rate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.rate() : this.rate;
    }

    public final TimescaleFilter withSpeed(@Nullable Float value) {
        if (Objects.equals(this.speed, value)) {
            return this;
        }
        return TimescaleFilter.validate(new TimescaleFilter(value, this.pitch, this.rate));
    }

    public final TimescaleFilter withPitch(@Nullable Float value) {
        if (Objects.equals(this.pitch, value)) {
            return this;
        }
        return TimescaleFilter.validate(new TimescaleFilter(this.speed, value, this.rate));
    }

    public final TimescaleFilter withRate(@Nullable Float value) {
        if (Objects.equals(this.rate, value)) {
            return this;
        }
        return TimescaleFilter.validate(new TimescaleFilter(this.speed, this.pitch, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof TimescaleFilter && this.equalTo((TimescaleFilter)another);
    }

    private boolean equalTo(TimescaleFilter another) {
        return Objects.equals(this.speed, another.speed) && Objects.equals(this.pitch, another.pitch) && Objects.equals(this.rate, another.rate);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.speed);
        h += (h << 5) + Objects.hashCode(this.pitch);
        h += (h << 5) + Objects.hashCode(this.rate);
        return h;
    }

    public String toString() {
        return "Timescale{speed=" + this.speed + ", pitch=" + this.pitch + ", rate=" + this.rate + "}";
    }

    public static TimescaleFilter of(@Nullable Float speed, @Nullable Float pitch, @Nullable Float rate) {
        return TimescaleFilter.validate(new TimescaleFilter(speed, pitch, rate));
    }

    private static TimescaleFilter validate(TimescaleFilter instance) {
        instance.check();
        return instance;
    }

    public static TimescaleFilter copyOf(PlayerFilter.Timescale instance) {
        if (instance instanceof TimescaleFilter) {
            return (TimescaleFilter)instance;
        }
        return TimescaleFilter.builder().from(instance).create();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="pw.aru.libs.andeclient.entities.player.PlayerFilter.Timescale", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SPEED = 1L;
        private static final long OPT_BIT_PITCH = 2L;
        private static final long OPT_BIT_RATE = 4L;
        private long optBits;
        @Nullable
        private Float speed;
        @Nullable
        private Float pitch;
        @Nullable
        private Float rate;

        private Builder() {
        }

        public final Builder from(PlayerFilter.Timescale instance) {
            Float rateValue;
            Float pitchValue;
            Objects.requireNonNull(instance, "instance");
            Float speedValue = instance.speed();
            if (speedValue != null) {
                this.speed(speedValue);
            }
            if ((pitchValue = instance.pitch()) != null) {
                this.pitch(pitchValue);
            }
            if ((rateValue = instance.rate()) != null) {
                this.rate(rateValue);
            }
            return this;
        }

        public final Builder speed(@Nullable Float speed) {
            this.speed = speed;
            this.optBits |= 1L;
            return this;
        }

        public final Builder pitch(@Nullable Float pitch) {
            this.pitch = pitch;
            this.optBits |= 2L;
            return this;
        }

        public final Builder rate(@Nullable Float rate) {
            this.rate = rate;
            this.optBits |= 4L;
            return this;
        }

        public TimescaleFilter create() {
            return TimescaleFilter.validate(new TimescaleFilter(this));
        }

        private boolean speedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean pitchIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean rateIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    @Generated(from="pw.aru.libs.andeclient.entities.player.PlayerFilter.Timescale", generator="Immutables")
    private final class InitShim {
        private byte speedBuildStage = 0;
        private Float speed;
        private byte pitchBuildStage = 0;
        private Float pitch;
        private byte rateBuildStage = 0;
        private Float rate;

        private InitShim() {
        }

        Float speed() {
            if (this.speedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.speedBuildStage == 0) {
                this.speedBuildStage = (byte)-1;
                this.speed = TimescaleFilter.super.speed();
                this.speedBuildStage = 1;
            }
            return this.speed;
        }

        void speed(Float speed) {
            this.speed = speed;
            this.speedBuildStage = 1;
        }

        Float pitch() {
            if (this.pitchBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pitchBuildStage == 0) {
                this.pitchBuildStage = (byte)-1;
                this.pitch = TimescaleFilter.super.pitch();
                this.pitchBuildStage = 1;
            }
            return this.pitch;
        }

        void pitch(Float pitch) {
            this.pitch = pitch;
            this.pitchBuildStage = 1;
        }

        Float rate() {
            if (this.rateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rateBuildStage == 0) {
                this.rateBuildStage = (byte)-1;
                this.rate = TimescaleFilter.super.rate();
                this.rateBuildStage = 1;
            }
            return this.rate;
        }

        void rate(Float rate) {
            this.rate = rate;
            this.rateBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.speedBuildStage == -1) {
                attributes.add("speed");
            }
            if (this.pitchBuildStage == -1) {
                attributes.add("pitch");
            }
            if (this.rateBuildStage == -1) {
                attributes.add("rate");
            }
            return "Cannot build Timescale, attribute initializers form cycle " + attributes;
        }
    }
}

