/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.internal;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONObject;
import pw.aru.lib.eventpipes.api.EventConsumer;
import pw.aru.lib.eventpipes.api.EventSubscription;
import pw.aru.libs.andeclient.entities.AndeClient;
import pw.aru.libs.andeclient.entities.AndePlayer;
import pw.aru.libs.andeclient.entities.AndesiteNode;
import pw.aru.libs.andeclient.entities.EntityState;
import pw.aru.libs.andeclient.entities.configurator.AndePlayerConfigurator;
import pw.aru.libs.andeclient.entities.player.PlayerControls;
import pw.aru.libs.andeclient.entities.player.PlayerFilter;
import pw.aru.libs.andeclient.events.AndeClientEvent;
import pw.aru.libs.andeclient.events.AndePlayerEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedNewPlayerEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedPlayerPauseEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedPlayerRemovedEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedPlayerResumeEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedPlayerUpdateEvent;
import pw.aru.libs.andeclient.internal.AndeClientImpl;
import pw.aru.libs.andeclient.internal.AndesiteNodeImpl;
import pw.aru.libs.andeclient.internal.PlayerControlsImpl;
import pw.aru.libs.andeclient.util.AndesiteUtil;

public class AndePlayerImpl
implements AndePlayer {
    private final AndeClientImpl client;
    final AndesiteNodeImpl node;
    private final long guildId;
    AudioTrack playingTrack;
    private PlayerControlsImpl playerControls;
    private long lastTime;
    private long lastPosition;
    private int lastVolume;
    private boolean isPaused;
    private Collection<? extends PlayerFilter> lastFilters;
    EntityState state = EntityState.CONFIGURING;

    public AndePlayerImpl(AndePlayerConfigurator configurator) {
        this.client = (AndeClientImpl)configurator.client();
        this.node = (AndesiteNodeImpl)configurator.andesiteNode();
        this.guildId = configurator.guildId();
        if (this.client.players.containsKey(this.guildId)) {
            this.state = EntityState.DESTROYED;
            throw new IllegalStateException("there's already a player for that guild!");
        }
        if (this.node.state() == EntityState.DESTROYED) {
            this.state = EntityState.DESTROYED;
            throw new IllegalStateException("the AndesiteNode provided is already destroyed. please create a new AndePlayer with a valid AndesiteNode.");
        }
        this.node.children.put(this.guildId, this);
        this.client.players.put(this.guildId, this);
        this.client.events.publish((Object)PostedNewPlayerEvent.of(this));
        this.state = EntityState.AVAILABLE;
    }

    @Override
    @Nonnull
    public AndesiteNode connectedNode() {
        return this.node;
    }

    @Override
    @Nonnull
    public AndeClient client() {
        return this.client;
    }

    @Override
    @Nonnull
    public EntityState state() {
        return this.state;
    }

    @Override
    @Nonnull
    public PlayerControls controls() {
        if (this.state == EntityState.DESTROYED) {
            throw new IllegalStateException("Destroyed AndePlayer, please create a new one with AndeClient#newPlayer.");
        }
        if (this.playerControls == null) {
            this.playerControls = new PlayerControlsImpl(this);
        }
        return this.playerControls;
    }

    @Override
    public long guildId() {
        return this.guildId;
    }

    @Override
    public long serverTime() {
        return this.lastTime;
    }

    @Override
    @Nullable
    public AudioTrack playingTrack() {
        return this.playingTrack;
    }

    @Override
    public long position() {
        return this.lastPosition;
    }

    @Override
    public int volume() {
        return this.lastVolume;
    }

    @Override
    public boolean paused() {
        return this.isPaused;
    }

    @Override
    public Collection<? extends PlayerFilter> filters() {
        return this.lastFilters;
    }

    @Override
    public void handleVoiceServerUpdate(String sessionId, String voiceToken, String endpoint) {
        if (this.state == EntityState.DESTROYED) {
            throw new IllegalStateException("Destroyed AndePlayer, please create a new one with AndeClient#newPlayer.");
        }
        this.node.handleOutcoming(new JSONObject().put("op", (Object)"voice-server-update").put("guildId", (Object)Long.toString(this.guildId)).put("sessionId", (Object)sessionId).put("event", (Object)new JSONObject().put("endpoint", (Object)endpoint).put("token", (Object)voiceToken)));
    }

    @Override
    public void destroy() {
        if (this.state == EntityState.DESTROYED) {
            return;
        }
        this.node.handleOutcoming(new JSONObject().put("op", (Object)"destroy").put("guildId", (Object)Long.toString(this.guildId)));
        this.state = EntityState.DESTROYED;
        this.playerControls = null;
        this.node.children.remove(this.guildId);
        this.client.players.remove(this.guildId);
        this.client.events.publish((Object)PostedPlayerRemovedEvent.of(this));
    }

    void update(JSONObject json) {
        if (this.state == EntityState.DESTROYED) {
            return;
        }
        boolean wasPaused = this.isPaused;
        this.lastTime = Long.parseLong(json.getString("time"));
        this.lastPosition = json.optInt("position", -1);
        this.isPaused = json.getBoolean("paused");
        this.lastVolume = json.getInt("volume");
        this.lastFilters = AndesiteUtil.playerFilters(json.getJSONObject("filters"));
        this.client.events.publish((Object)PostedPlayerUpdateEvent.builder().player(this).timestamp(this.lastTime).position(this.lastPosition).volume(this.lastVolume).filters(this.lastFilters).build());
        if (wasPaused && !this.isPaused) {
            this.client.events.publish((Object)PostedPlayerResumeEvent.of(this));
        } else if (!wasPaused && this.isPaused) {
            this.client.events.publish((Object)PostedPlayerPauseEvent.of(this));
        }
    }

    @Override
    public EventSubscription<AndeClientEvent> on(EventConsumer<AndePlayerEvent> consumer) {
        return this.client.on((EventConsumer<AndeClientEvent>)((EventConsumer)event -> {
            if (event instanceof AndePlayerEvent && ((AndePlayerEvent)event).player() == this) {
                consumer.onEvent((Object)((AndePlayerEvent)event));
            }
        }));
    }
}

