/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.entities.player;

import javax.annotation.Nullable;
import org.immutables.value.Value;
import pw.aru.libs.andeclient.annotations.Filter;
import pw.aru.libs.andeclient.entities.player.internal.KaraokeFilter;
import pw.aru.libs.andeclient.entities.player.internal.TimescaleFilter;
import pw.aru.libs.andeclient.entities.player.internal.TremoloFilter;
import pw.aru.libs.andeclient.entities.player.internal.VibratoFilter;
import pw.aru.libs.andeclient.entities.player.internal.VolumeFilter;

public abstract class PlayerFilter {
    private PlayerFilter() {
    }

    public static Equalizer equalizer() {
        return new Equalizer();
    }

    public static KaraokeFilter.Builder karaoke() {
        return KaraokeFilter.builder();
    }

    public static TimescaleFilter.Builder timescale() {
        return TimescaleFilter.builder();
    }

    public static TremoloFilter.Builder tremolo() {
        return TremoloFilter.builder();
    }

    public static VibratoFilter.Builder vibrato() {
        return VibratoFilter.builder();
    }

    public static PlayerFilter volume(Float volume) {
        return VolumeFilter.of(volume);
    }

    public static PlayerFilter volume(int volume) {
        return VolumeFilter.of(Float.valueOf(volume));
    }

    @Value.Immutable
    @Filter
    public static abstract class Volume
    extends PlayerFilter {
        @Nullable
        public abstract Float value();
    }

    @Value.Immutable
    @Filter
    public static abstract class Vibrato
    extends PlayerFilter {
        @Nullable
        @Value.Default
        public Float frequency() {
            return Float.valueOf(2.0f);
        }

        @Nullable
        @Value.Default
        public Float depth() {
            return Float.valueOf(0.5f);
        }

        @Value.Check
        protected void check() {
            Float frequency = this.frequency();
            if (frequency != null && (frequency.floatValue() <= 0.0f || frequency.floatValue() > 14.0f)) {
                throw new IllegalArgumentException("frequency out of range (0 < depth <= 14)");
            }
            Float depth = this.depth();
            if (depth != null && (depth.floatValue() <= 0.0f || depth.floatValue() > 1.0f)) {
                throw new IllegalArgumentException("depth out of range (0 < depth <= 1)");
            }
        }
    }

    @Value.Immutable
    @Filter
    public static abstract class Tremolo
    extends PlayerFilter {
        @Nullable
        @Value.Default
        public Float frequency() {
            return Float.valueOf(2.0f);
        }

        @Nullable
        @Value.Default
        public Float depth() {
            return Float.valueOf(0.5f);
        }

        @Value.Check
        protected void check() {
            Float frequency = this.frequency();
            if (frequency != null && frequency.floatValue() <= 0.0f) {
                throw new IllegalArgumentException("frequency out of range (> 0)");
            }
            Float depth = this.depth();
            if (depth != null && (depth.floatValue() <= 0.0f || depth.floatValue() > 1.0f)) {
                throw new IllegalArgumentException("depth out of range (0 < depth <= 1)");
            }
        }
    }

    @Value.Immutable
    @Filter
    public static abstract class Timescale
    extends PlayerFilter {
        @Nullable
        @Value.Default
        public Float speed() {
            return Float.valueOf(1.0f);
        }

        @Nullable
        @Value.Default
        public Float pitch() {
            return Float.valueOf(1.0f);
        }

        @Nullable
        @Value.Default
        public Float rate() {
            return Float.valueOf(1.0f);
        }

        @Value.Check
        protected void check() {
            Float speed = this.speed();
            if (speed != null && speed.floatValue() <= 0.0f) {
                throw new IllegalArgumentException("speed out of range (> 0)");
            }
            Float pitch = this.pitch();
            if (pitch != null && pitch.floatValue() <= 0.0f) {
                throw new IllegalArgumentException("pitch out of range (> 0)");
            }
            Float rate = this.rate();
            if (rate != null && rate.floatValue() <= 0.0f) {
                throw new IllegalArgumentException("rate out of range (> 0)");
            }
        }
    }

    @Value.Immutable
    @Filter
    public static abstract class Karaoke
    extends PlayerFilter {
        @Nullable
        @Value.Default
        public Float level() {
            return Float.valueOf(1.0f);
        }

        @Nullable
        @Value.Default
        public Float monoLevel() {
            return Float.valueOf(1.0f);
        }

        @Nullable
        @Value.Default
        public Float filterBand() {
            return Float.valueOf(220.0f);
        }

        @Nullable
        @Value.Default
        public Float filterWidth() {
            return Float.valueOf(110.0f);
        }
    }

    @Filter
    public static class Equalizer
    extends PlayerFilter {
        private Float[] bands = new Float[15];

        public Equalizer withBand(int band, Float gain) {
            if (band < 0 || band > 14) {
                throw new IllegalArgumentException("band out of range [0, 14]");
            }
            if (gain != null && (gain.floatValue() < -0.25f || gain.floatValue() > 1.0f)) {
                throw new IllegalArgumentException("band out of range [-0.25, 1.0]");
            }
            this.bands[band] = gain;
            return this;
        }

        public Float[] bands() {
            return (Float[])this.bands.clone();
        }
    }
}

