/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.util;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.bandcamp.BandcampAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.beam.BeamAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.http.HttpAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.vimeo.VimeoAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.io.MessageInput;
import com.sedmelluq.discord.lavaplayer.tools.io.MessageOutput;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import net.iharder.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pw.aru.libs.andeclient.exceptions.LocalTrackException;

public class AudioTrackUtil {
    private static final AudioPlayerManager manager = new DefaultAudioPlayerManager();
    private static final Logger logger = LoggerFactory.getLogger(AudioTrackUtil.class);

    @CheckReturnValue
    @Nonnull
    public static AudioTrack fromString(@Nonnull String data) {
        try {
            return AudioTrackUtil.manager.decodeTrack((MessageInput)new MessageInput((InputStream)new ByteArrayInputStream((byte[])Base64.decode((String)data)))).decodedTrack;
        }
        catch (IOException e) {
            logger.error("error when decoding track: {} | {}", (Object)data, (Object)e);
            throw new LocalTrackException(e);
        }
    }

    @CheckReturnValue
    @Nonnull
    public static String fromTrack(@Nonnull AudioTrack track) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            manager.encodeTrack(new MessageOutput((OutputStream)stream), track);
            return Base64.encodeBytes((byte[])stream.toByteArray());
        }
        catch (IOException e) {
            logger.error("error when encoding track: {} | {}", (Object)track.getIdentifier(), (Object)e);
            throw new LocalTrackException(e);
        }
    }

    static {
        manager.registerSourceManager((AudioSourceManager)new YoutubeAudioSourceManager(true));
        manager.registerSourceManager((AudioSourceManager)new SoundCloudAudioSourceManager(true));
        manager.registerSourceManager((AudioSourceManager)new BeamAudioSourceManager());
        manager.registerSourceManager((AudioSourceManager)new BandcampAudioSourceManager());
        manager.registerSourceManager((AudioSourceManager)new TwitchStreamAudioSourceManager());
        manager.registerSourceManager((AudioSourceManager)new HttpAudioSourceManager());
        manager.registerSourceManager((AudioSourceManager)new VimeoAudioSourceManager());
    }
}

