/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.internal;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONObject;
import pw.aru.lib.eventpipes.api.EventConsumer;
import pw.aru.lib.eventpipes.api.EventSubscription;
import pw.aru.libs.andeclient.entities.AndeClient;
import pw.aru.libs.andeclient.entities.AndePlayer;
import pw.aru.libs.andeclient.entities.AndesiteNode;
import pw.aru.libs.andeclient.entities.configurator.AndePlayerConfigurator;
import pw.aru.libs.andeclient.entities.player.PlayerControls;
import pw.aru.libs.andeclient.entities.player.PlayerFilter;
import pw.aru.libs.andeclient.events.AndeClientEvent;
import pw.aru.libs.andeclient.events.AndePlayerEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedNewPlayerEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedPlayerPauseEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedPlayerRemovedEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedPlayerResumeEvent;
import pw.aru.libs.andeclient.events.player.internal.PostedPlayerUpdateEvent;
import pw.aru.libs.andeclient.internal.AndeClientImpl;
import pw.aru.libs.andeclient.internal.AndesiteNodeImpl;
import pw.aru.libs.andeclient.internal.PlayerControlsImpl;
import pw.aru.libs.andeclient.util.AndesiteUtil;

public class AndePlayerImpl
implements AndePlayer {
    private final AndeClientImpl client;
    final AndesiteNodeImpl node;
    private final long guildId;
    AudioTrack playingTrack;
    private PlayerControlsImpl playerControls;
    private long lastTime;
    private long lastPosition;
    private int lastVolume;
    private boolean isPaused;
    private Collection<? extends PlayerFilter> lastFilters;

    public AndePlayerImpl(AndePlayerConfigurator configurator) {
        this.client = (AndeClientImpl)configurator.client();
        this.node = (AndesiteNodeImpl)configurator.andesiteNode();
        this.guildId = configurator.guildId();
        if (this.client.players.containsKey(this.guildId)) {
            throw new IllegalStateException("there's already a player for that guild!");
        }
        this.node.children.put(this.guildId, this);
        this.client.players.put(this.guildId, this);
        this.client.events.publish((Object)PostedNewPlayerEvent.of(this));
    }

    @Override
    @Nonnull
    public AndesiteNode connectedNode() {
        return this.node;
    }

    @Override
    @Nonnull
    public AndeClient client() {
        return this.client;
    }

    @Override
    @Nonnull
    public PlayerControls controls() {
        if (this.playerControls == null) {
            this.playerControls = new PlayerControlsImpl(this);
        }
        return this.playerControls;
    }

    @Override
    public long guildId() {
        return this.guildId;
    }

    @Override
    public long serverTime() {
        return this.lastTime;
    }

    @Override
    @Nullable
    public AudioTrack playingTrack() {
        return this.playingTrack;
    }

    @Override
    public long position() {
        return this.lastPosition;
    }

    @Override
    public int volume() {
        return this.lastVolume;
    }

    @Override
    public boolean paused() {
        return this.isPaused;
    }

    @Override
    public Collection<? extends PlayerFilter> filters() {
        return this.lastFilters;
    }

    @Override
    public void handleVoiceServerUpdate(String sessionId, String voiceToken, String endpoint) {
        this.node.handleOutcoming(new JSONObject().put("op", (Object)"voice-server-update").put("guildId", (Object)Long.toString(this.guildId)).put("sessionId", (Object)sessionId).put("event", (Object)new JSONObject().put("endpoint", (Object)endpoint).put("token", (Object)voiceToken)));
    }

    @Override
    public void destroy() {
        this.node.handleOutcoming(new JSONObject().put("op", (Object)"destroy").put("guildId", (Object)Long.toString(this.guildId)));
        this.node.children.remove(this.guildId);
        this.client.players.remove(this.guildId);
        this.client.events.publish((Object)PostedPlayerRemovedEvent.of(this));
    }

    void update(JSONObject state) {
        boolean wasPaused = this.isPaused;
        this.lastTime = Long.parseLong(state.getString("time"));
        this.lastPosition = state.optInt("position", -1);
        this.isPaused = state.getBoolean("paused");
        this.lastVolume = state.getInt("volume");
        this.lastFilters = AndesiteUtil.playerFilters(state.getJSONObject("filters"));
        this.client.events.publish((Object)PostedPlayerUpdateEvent.builder().player(this).timestamp(this.lastTime).position(this.lastPosition).volume(this.lastVolume).filters(this.lastFilters).build());
        if (wasPaused && !this.isPaused) {
            this.client.events.publish((Object)PostedPlayerResumeEvent.of(this));
        } else if (!wasPaused && this.isPaused) {
            this.client.events.publish((Object)PostedPlayerPauseEvent.of(this));
        }
    }

    @Override
    public EventSubscription<AndeClientEvent> on(EventConsumer<AndePlayerEvent> consumer) {
        return this.client.on((EventConsumer<AndeClientEvent>)((EventConsumer)event -> {
            if (event instanceof AndePlayerEvent && ((AndePlayerEvent)event).player() == this) {
                consumer.onEvent((Object)((AndePlayerEvent)event));
            }
        }));
    }
}

