/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.andeclient.entities;

import java.util.List;
import java.util.concurrent.CompletionStage;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import org.immutables.value.Value;
import org.json.JSONObject;
import pw.aru.lib.eventpipes.api.EventConsumer;
import pw.aru.lib.eventpipes.api.EventSubscription;
import pw.aru.libs.andeclient.annotations.SimpleData;
import pw.aru.libs.andeclient.entities.AndeClient;
import pw.aru.libs.andeclient.entities.AudioLoadResult;
import pw.aru.libs.andeclient.events.AndeClientEvent;
import pw.aru.libs.andeclient.events.AndesiteNodeEvent;
import pw.aru.libs.andeclient.events.EventType;

public interface AndesiteNode {
    @Nonnull
    @CheckReturnValue
    public AndeClient client();

    @CheckReturnValue
    public boolean ready();

    @Nonnull
    @CheckReturnValue
    public Info nodeInfo();

    @Nonnull
    @CheckReturnValue
    public CompletionStage<Stats> stats();

    @Nonnull
    @CheckReturnValue
    public CompletionStage<AudioLoadResult> loadTracksAsync(String var1);

    public EventSubscription<AndeClientEvent> on(EventConsumer<AndesiteNodeEvent> var1);

    default public <T extends AndesiteNodeEvent> EventSubscription<AndeClientEvent> on(EventType<T> type, EventConsumer<T> consumer) {
        return this.on((EventConsumer<AndesiteNodeEvent>)((EventConsumer)event -> {
            if (event.type() == type) {
                consumer.onEvent(event);
            }
        }));
    }

    public void destroy();

    @Value.Immutable
    @SimpleData
    public static interface Stats {
        public AndesiteNode node();

        public JSONObject raw();

        public int players();

        public int playingPlayers();

        public long uptime();

        public double systemLoad();

        public double andesiteLoad();

        public long sentFrames();

        public long nulledFrames();

        public long deficitFrames();
    }

    @Value.Immutable
    @SimpleData
    public static interface Info {
        public String version();

        public String versionMajor();

        public String versionMinor();

        public String versionRevision();

        public long versionBuild();

        public String versionCommit();

        public String nodeRegion();

        public String nodeId();

        public List<String> enabledSources();

        public List<String> loadedPlugins();
    }
}

