/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.dd4j;

import org.json.JSONException;
import org.json.JSONObject;

public final class SimpleAnswer {
    private final String htmlResult;
    private final String firstUrl;
    private final String firstUrlText;
    private final String iconUrl;
    private final int iconWidth;
    private final int iconHeight;

    public SimpleAnswer(String htmlResult, String firstUrl, String firstUrlText, String iconUrl, int iconWidth, int iconHeight) {
        this.htmlResult = htmlResult;
        this.firstUrl = firstUrl;
        this.firstUrlText = firstUrlText;
        this.iconUrl = iconUrl;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
    }

    protected static SimpleAnswer fromJSON(JSONObject topicJson) {
        try {
            int iconHeight;
            int iconWidth;
            String htmlResult = topicJson.optString("Result");
            String firstUrl = topicJson.optString("FirstURL");
            String firstUrlText = topicJson.optString("Text");
            JSONObject iconJson = topicJson.optJSONObject("Icon");
            if (iconJson == null) {
                return new SimpleAnswer(htmlResult, firstUrl, firstUrlText, null, 0, 0);
            }
            String iconUrl = iconJson.optString("URL");
            try {
                iconWidth = Integer.parseInt(iconJson.optString("Width"));
            }
            catch (NumberFormatException | JSONException e) {
                iconWidth = 0;
            }
            try {
                iconHeight = Integer.parseInt(iconJson.optString("Height"));
            }
            catch (NumberFormatException | JSONException e) {
                iconHeight = 0;
            }
            return new SimpleAnswer(htmlResult.equals("") ? null : htmlResult, firstUrl.equals("") ? null : firstUrl, firstUrlText.equals("") ? null : firstUrlText, iconUrl.equals("") ? null : iconUrl, iconWidth, iconHeight);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Error parsing JSON of SimpleAnswer", e);
        }
    }

    public String getHtmlResult() {
        return this.htmlResult;
    }

    public String getFirstUrl() {
        return this.firstUrl;
    }

    public String getFirstUrlText() {
        return this.firstUrlText;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public String toString() {
        return "SimpleAnswer{htmlResult='" + this.htmlResult + '\'' + ", firstUrl='" + this.firstUrl + '\'' + ", firstUrlText='" + this.firstUrlText + '\'' + ", iconUrl='" + this.iconUrl + '\'' + ", iconWidth=" + this.iconWidth + ", iconHeight=" + this.iconHeight + '}';
    }
}

