/*
 * Decompiled with CFR 0.152.
 */
package pw.aru.libs.dd4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pw.aru.libs.dd4j.AnswerType;
import pw.aru.libs.dd4j.SimpleAnswer;

public final class InstantAnswer {
    private final String link;
    private final AnswerType type;
    private final String redirectUrl;
    private final String abstractHtml;
    private final String abstractText;
    private final String abstractSource;
    private final String abstractUrl;
    private final String imageUrl;
    private final String heading;
    private final Object answer;
    private final String answerType;
    private final String definitionText;
    private final String definitionSource;
    private final String definitionUrl;
    private final List<SimpleAnswer> relatedTopics;
    private final List<SimpleAnswer> results;

    public InstantAnswer(String link, AnswerType type, String redirectUrl, String abstractHtml, String abstractText, String abstractSource, String abstractUrl, String imageUrl, String heading, Object answer, String answerType, String definitionText, String definitionSource, String definitionUrl, List<SimpleAnswer> relatedTopics, List<SimpleAnswer> results) {
        this.link = link;
        this.type = type;
        this.redirectUrl = redirectUrl;
        this.abstractHtml = abstractHtml;
        this.abstractText = abstractText;
        this.abstractSource = abstractSource;
        this.abstractUrl = abstractUrl;
        this.imageUrl = imageUrl;
        this.heading = heading;
        this.answer = answer;
        this.answerType = answerType;
        this.definitionText = definitionText;
        this.definitionSource = definitionSource;
        this.definitionUrl = definitionUrl;
        this.relatedTopics = relatedTopics;
        this.results = results;
    }

    protected static InstantAnswer fromJSON(String encodedQuery, String encodedAppName, JSONObject obj) {
        try {
            String link = "https://duckduckgo.com/?q=" + encodedQuery + "&t=" + encodedAppName;
            AnswerType type = AnswerType.fromString(obj.getString("Type"));
            String redirectUrl = obj.getString("Redirect");
            String abstractHtml = obj.getString("Abstract");
            String abstractText = obj.getString("AbstractText");
            String abstractSource = obj.getString("AbstractSource");
            String abstractUrl = obj.getString("AbstractURL");
            String imageUrl = obj.getString("Image");
            String heading = obj.getString("Heading");
            Object answer = obj.get("Answer");
            String answerType = obj.getString("AnswerType");
            String definitionText = obj.getString("Definition");
            String definitionSource = obj.getString("DefinitionSource");
            String definitionUrl = obj.getString("DefinitionURL");
            JSONArray topicsArray = obj.getJSONArray("RelatedTopics");
            ArrayList<SimpleAnswer> relatedTopics = new ArrayList<SimpleAnswer>(topicsArray.length());
            for (int i = 0; i < topicsArray.length(); ++i) {
                relatedTopics.add(SimpleAnswer.fromJSON(topicsArray.getJSONObject(i)));
            }
            JSONArray resultsArray = obj.getJSONArray("Results");
            ArrayList<SimpleAnswer> results = new ArrayList<SimpleAnswer>(topicsArray.length());
            for (int i = 0; i < resultsArray.length(); ++i) {
                results.add(SimpleAnswer.fromJSON(resultsArray.getJSONObject(i)));
            }
            return new InstantAnswer(link, type, redirectUrl.equals("") ? null : redirectUrl, abstractHtml.equals("") ? null : abstractHtml, abstractText.equals("") ? null : abstractText, abstractSource.equals("") ? null : abstractSource, abstractUrl.equals("") ? null : abstractUrl, imageUrl.equals("") ? null : imageUrl, heading.equals("") ? null : heading, answer.equals("") ? null : answer, answerType.equals("") ? null : answerType, definitionText.equals("") ? null : definitionText, definitionSource.equals("") ? null : definitionSource, definitionUrl.equals("") ? null : definitionUrl, Collections.unmodifiableList(relatedTopics), Collections.unmodifiableList(results));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Error parsing JSON of InstantAnswer", e);
        }
    }

    public String getLink() {
        return this.link;
    }

    public AnswerType getType() {
        return this.type;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public String getAbstractHtml() {
        return this.abstractHtml;
    }

    public String getAbstractText() {
        return this.abstractText;
    }

    public String getAbstractSource() {
        return this.abstractSource;
    }

    public String getAbstractUrl() {
        return this.abstractUrl;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getHeading() {
        return this.heading;
    }

    public Object getAnswer() {
        return this.answer;
    }

    public String getAnswerType() {
        return this.answerType;
    }

    public String getDefinitionText() {
        return this.definitionText;
    }

    public String getDefinitionSource() {
        return this.definitionSource;
    }

    public String getDefinitionUrl() {
        return this.definitionUrl;
    }

    public List<SimpleAnswer> getRelatedTopics() {
        return this.relatedTopics;
    }

    public List<SimpleAnswer> getResults() {
        return this.results;
    }

    public String toString() {
        return "InstantAnswer{link='" + this.link + '\'' + ", type=" + (Object)((Object)this.type) + ", redirectUrl='" + this.redirectUrl + '\'' + ", abstractHtml='" + this.abstractHtml + '\'' + ", abstractText='" + this.abstractText + '\'' + ", abstractSource='" + this.abstractSource + '\'' + ", abstractUrl='" + this.abstractUrl + '\'' + ", imageUrl='" + this.imageUrl + '\'' + ", heading='" + this.heading + '\'' + ", answer=" + this.answer + ", answerType='" + this.answerType + '\'' + ", definitionText='" + this.definitionText + '\'' + ", definitionSource='" + this.definitionSource + '\'' + ", definitionUrl='" + this.definitionUrl + '\'' + ", relatedTopics=" + this.relatedTopics + ", results=" + this.results + '}';
    }
}

