/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl;

import com.puppetlabs.http.client.impl.Deliverable;
import com.puppetlabs.http.client.impl.ExceptionInsertingPipedInputStream;
import com.puppetlabs.http.client.impl.Promise;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;
import org.apache.http.HttpResponse;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.client.methods.AsyncByteConsumer;
import org.apache.http.protocol.HttpContext;

public class StreamingAsyncResponseConsumer
extends AsyncByteConsumer<HttpResponse> {
    private volatile HttpResponse response;
    private volatile PipedOutputStream pos;
    private volatile Deliverable<HttpResponse> promise;
    private volatile Promise<IOException> ioExceptionPromise = new Promise();

    public void setFinalResult(IOException iOException) {
        this.ioExceptionPromise.deliver(iOException);
    }

    public StreamingAsyncResponseConsumer(Deliverable<HttpResponse> deliverable) {
        this.promise = deliverable;
    }

    protected void onResponseReceived(HttpResponse httpResponse) throws IOException {
        ExceptionInsertingPipedInputStream exceptionInsertingPipedInputStream = new ExceptionInsertingPipedInputStream(this.ioExceptionPromise);
        this.pos = new PipedOutputStream();
        this.pos.connect(exceptionInsertingPipedInputStream);
        ((BasicHttpEntity)httpResponse.getEntity()).setContent((InputStream)exceptionInsertingPipedInputStream);
        this.response = httpResponse;
        this.promise.deliver(httpResponse);
    }

    protected void onByteReceived(ByteBuffer byteBuffer, IOControl iOControl) throws IOException {
        while (byteBuffer.hasRemaining()) {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            this.pos.write(byArray);
        }
    }

    protected void releaseResources() {
        super.releaseResources();
        this.response = null;
        this.promise = null;
        try {
            if (this.pos != null) {
                this.pos.close();
                this.pos = null;
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    protected HttpResponse buildResult(HttpContext httpContext) {
        return this.response;
    }
}

