/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client.impl;

import com.puppetlabs.certificate_authority.CertificateAuthority;
import com.puppetlabs.http.client.ClientOptions;
import com.puppetlabs.http.client.HttpClientException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslUtils.class);

    private static void logAndRethrow(String string, Throwable throwable) {
        LOGGER.error(string, throwable);
        throw new HttpClientException(string, throwable);
    }

    public static ClientOptions configureSsl(ClientOptions clientOptions) {
        if (clientOptions.getSslContext() != null) {
            return clientOptions;
        }
        if (clientOptions.getSslCert() != null && clientOptions.getSslKey() != null && clientOptions.getSslCaCert() != null) {
            try {
                clientOptions.setSslContext(CertificateAuthority.pemsToSSLContext((Reader)new FileReader(clientOptions.getSslCert()), (Reader)new FileReader(clientOptions.getSslKey()), (Reader)new FileReader(clientOptions.getSslCaCert())));
            }
            catch (KeyStoreException keyStoreException) {
                SslUtils.logAndRethrow("Error while configuring SSL", keyStoreException);
            }
            catch (CertificateException certificateException) {
                SslUtils.logAndRethrow("Error while configuring SSL", certificateException);
            }
            catch (IOException iOException) {
                SslUtils.logAndRethrow("Error while configuring SSL", iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                SslUtils.logAndRethrow("Error while configuring SSL", noSuchAlgorithmException);
            }
            catch (KeyManagementException keyManagementException) {
                SslUtils.logAndRethrow("Error while configuring SSL", keyManagementException);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                SslUtils.logAndRethrow("Error while configuring SSL", unrecoverableKeyException);
            }
            clientOptions.setSslCert(null);
            clientOptions.setSslKey(null);
            clientOptions.setSslCaCert(null);
            return clientOptions;
        }
        if (clientOptions.getSslCaCert() != null) {
            try {
                clientOptions.setSslContext(CertificateAuthority.caCertPemToSSLContext((Reader)new FileReader(clientOptions.getSslCaCert())));
            }
            catch (KeyStoreException keyStoreException) {
                SslUtils.logAndRethrow("Error while configuring SSL", keyStoreException);
            }
            catch (CertificateException certificateException) {
                SslUtils.logAndRethrow("Error while configuring SSL", certificateException);
            }
            catch (IOException iOException) {
                SslUtils.logAndRethrow("Error while configuring SSL", iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                SslUtils.logAndRethrow("Error while configuring SSL", noSuchAlgorithmException);
            }
            catch (KeyManagementException keyManagementException) {
                SslUtils.logAndRethrow("Error while configuring SSL", keyManagementException);
            }
            clientOptions.setSslCaCert(null);
            return clientOptions;
        }
        return clientOptions;
    }
}

