/*
 * Decompiled with CFR 0.152.
 */
package com.puppetlabs.http.client;

import com.puppetlabs.http.client.HttpClientException;
import com.puppetlabs.http.client.HttpMethod;
import com.puppetlabs.http.client.RequestOptions;
import com.puppetlabs.http.client.Response;
import com.puppetlabs.http.client.impl.JavaClient;
import com.puppetlabs.http.client.impl.Promise;
import com.puppetlabs.http.client.impl.SslUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncHttpClient.class);

    private static void logAndRethrow(String string, Throwable throwable) {
        LOGGER.error(string, throwable);
        throw new HttpClientException(string, throwable);
    }

    public static Response request(RequestOptions requestOptions) {
        requestOptions = SslUtils.configureSsl(requestOptions);
        Promise<Response> promise = JavaClient.request(requestOptions, null);
        Response response = null;
        try {
            response = promise.deref();
        }
        catch (InterruptedException interruptedException) {
            SyncHttpClient.logAndRethrow("Error while waiting for http response", interruptedException);
        }
        if (response.getError() != null) {
            SyncHttpClient.logAndRethrow("Error executing http request", response.getError());
        }
        return response;
    }

    public static Response get(String string) {
        return SyncHttpClient.get(new RequestOptions(string));
    }

    public static Response get(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.GET));
    }

    public static Response head(String string) {
        return SyncHttpClient.head(new RequestOptions(string));
    }

    public static Response head(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.HEAD));
    }

    public static Response post(String string) {
        return SyncHttpClient.post(new RequestOptions(string));
    }

    public static Response post(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.POST));
    }

    public static Response put(String string) {
        return SyncHttpClient.put(new RequestOptions(string));
    }

    public static Response put(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.PUT));
    }

    public static Response delete(String string) {
        return SyncHttpClient.delete(new RequestOptions(string));
    }

    public static Response delete(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.DELETE));
    }

    public static Response trace(String string) {
        return SyncHttpClient.trace(new RequestOptions(string));
    }

    public static Response trace(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.TRACE));
    }

    public static Response options(String string) {
        return SyncHttpClient.options(new RequestOptions(string));
    }

    public static Response options(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.OPTIONS));
    }

    public static Response patch(String string) {
        return SyncHttpClient.patch(new RequestOptions(string));
    }

    public static Response patch(RequestOptions requestOptions) {
        return SyncHttpClient.request(requestOptions.setMethod(HttpMethod.PATCH));
    }
}

