(ns {{project-ns}}.test-resources.utils
  (:require [reagent.core :as reagent]))

(def isClient (not (nil? (try (.-document js/window)
                              (catch js/Object e nil)))))

(def rflush reagent/flush)

(defn add-test-div [name]
  (let [doc     js/document
        body    (.-body js/document)
        div     (.createElement doc "div")]
    (.appendChild body div)
    div))

(defn with-mounted-component [comp f]
  (when isClient
    (let [div (add-test-div "_testreagent")]
      (let [comp (reagent/render-component comp div #(f comp div))]
        (reagent/unmount-component-at-node div)
        (reagent/flush)
        (.removeChild (.-body js/document) div)))))

(defn log-test-info [action-attempted searched-for searched-in]
  (println "\n<><>>>> Failed Test Info <<<<><>")
  (println searched-for action-attempted)
  (println searched-in)
  (println "<><><>"))

(defn regex-found-in-component? [re comp]
  (with-mounted-component comp
    (fn [c div]
      (let [res (.-innerHTML div)]
        (if (re-find re res) true (log-test-info " Was not found in: \n" re res))))))

(defn regex-not-found-in-component? [re comp]
  (with-mounted-component comp
    (fn [c div]
      (let [res (.-innerHTML div)]
        (if (not (re-find re res)) true (log-test-info " Was not found in: \n" re res))))))
