(ns leiningen.new.prewired-reagent-template
  (:require [leiningen.core.main :as main]
            [leiningen.new.templates :refer [renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "prewired-reagent-template"))

(defn prewired-reagent-template [name & opts]
  (let [data {:name       name
              :sanitized  (name-to-path name)
              :project-ns (sanitize-ns name)}]
    (main/info "=====\nPrewiring the template.\n")
    (->files data
             ["README.md"                                    (render "README.md"            data)]
             ["project.clj"                                  (render "project.clj"          data)]
             ["src/{{sanitized}}/core.cljs"                  (render "core.cljs"            data)]
             ["src/{{sanitized}}/global_state.cljs"          (render "global_state.cljs"    data)]
             ["src/{{sanitized}}/router.cljs"                (render "router.cljs"          data)]
             ["src/{{sanitized}}/routes/index.cljs"          (render "index.cljs"           data)]
             ["src/{{sanitized}}/routes/demo_route.cljs"     (render "demo_route.cljs"      data)]
             ["test/{{sanitized}}/runner.cljs"               (render "runner.cljs"          data)]
             ["test/{{sanitized}}/test_resources/utils.cljs" (render "utils.cljs"           data)]
             ["test/{{sanitized}}/demo_route_test.cljs"      (render "demo_route_test.cljs" data)]
             ["resources/public/index.html"                  (render "index.html"           data)]
             ["less/site.less"                               (render "site.less"            data)]
             [".gitignore"                                   (render "gitignore"            data)])
    (main/info "You are good to go.\n=====")))
