(ns leiningen.polylith.cmd.help.info)

(defn help []
  (println "  Show the content of a Polylith workspace and its changes since")
  (println "  the last successful build or a given point in time")
  (println "  (each row is followed by an * if something has changed).")
  (println)
  (println "  lein polylith info [ARG]")
  (println "    ARG = (omitted) -> Since last successful build, stored in bookmark")
  (println "                       :last-successful-build in WS-ROOT/.polylith/time.edn. or")
  (println "                       :last-successful-build in WS-ROOT/.polylith/git.edn if")
  (println "                       you have CI variable set to something on the machine.")
  (println "          timestamp -> Since the given timestamp (milliseconds since 1970).")
  (println "          git-hash  -> Since the given git hash if the CI variable is set.")
  (println "          bookmark  -> Since the timestamp for the given bookmark in WS-ROOT/.polylith/time.edn or")
  (println "                       since the git hash for the given bookmark in WS-ROOT/.polylith/git.edn if CI")
  (println "                       variable set.")
  (println)
  (println "  example:")
  (println "    lein polylith info")
  (println "    lein polylith info 1523649477000")
  (println "    lein polylith info 7d7fd132412aad0f8d3019edfccd1e9d92a5a8ae")
  (println "    lein polylith info mybookmark"))
