(ns leiningen.polylith.cmd.help.build)

(defn help []
  (println "  Build artifacts.")
  (println)
  (println "  lein polylith build [ARG] [SKIP]")
  (println "    ARG = (omitted) -> Since last successful build, stored in bookmark")
  (println "                       :last-successful-build in WS-ROOT/.polylith/time.edn. or")
  (println "                       :last-successful-build in WS-ROOT/.polylith/git.edn if")
  (println "                       you have CI variable set to something on the machine.")
  (println "          timestamp -> Since the given timestamp (milliseconds since 1970).")
  (println "          git-hash  -> Since the given git hash if CI variable set.")
  (println "          bookmark  -> Since the timestamp for the given bookmark in WS-ROOT/.polylith/time.edn or")
  (println "                       since the git hash for the given bookmark in WS-ROOT/.polylith/git.edn if CI")
  (println "                       variable set.")
  (println)
  (println "    SKIP = (omitted) -> Compiles, tests, builds, and sets :last-successful-build")
  (println "           -compile -> Skips compilation step")
  (println "           -test    -> Skips test step")
  (println "           -success -> Skips success step")
  (println)
  (println "  examples:")
  (println "    lein polylith build")
  (println "    lein polylith build -compile")
  (println "    lein polylith build 1523649477000")
  (println "    lein polylith build 7d7fd132412aad0f8d3019edfccd1e9d92a5a8ae")
  (println "    lein polylith build mybookmark")
  (println "    lein polylith build 1523649477000 -compile -test"))

