(ns leiningen.polylith
  (:require [leiningen.polylith.cmd :as cmd]
            [leiningen.polylith.file :as file]))

(defn ^:no-project-needed polylith
  {:help-arglists '([cmd/deps
                     cmd/changes
                     cmd/help
                     cmd/info
                     cmd/settings
                     cmd/test])
   :subtasks [#'cmd/deps
              #'cmd/changes
              #'cmd/help
              #'cmd/info
              #'cmd/settings
              #'cmd/test]}
  ([project]
   (cmd/help))
  ([project subtask & args]
   (let [settings (:polylith project)
         root-dir (or (:root-dir settings) (file/parent-path))
         ignore-tests (or (:ignore-tests settings) [])]
     (case subtask
       "deps" (cmd/deps root-dir)
       "changes" (cmd/changes root-dir args)
       "help" (cmd/help)
       "info" (cmd/info root-dir args)
       "settings" (cmd/settings root-dir settings)
       "test" (cmd/test root-dir ignore-tests args)
       (cmd/task-not-found subtask)))))
