package playfun.ads.android.sdk.component.factory.nativeads;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;

import org.w3c.dom.Text;

import java.util.ArrayList;
import java.util.List;

import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.factory.nativeads.adapter.AdapterBottomAds;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.model.networkmodel.DataImage;

public class NativeAdsBottom extends RelativeLayout {

    private ViewPager viewPager;
    AdapterBottomAds adapter;
    List<DataImage> listImage = new ArrayList<>();
    private ImageView img_icon_game;
    private TextView text_title_game , text_description_game , tv_download_game;
    private ImageView icon_download_game;
    private RelativeLayout view_download_game;
    private LinearLayout layout_content_bottom_native;

    public NativeAdsBottom(Context context) {
        this(context, null);
    }

    public NativeAdsBottom(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NativeAdsBottom(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from(context).inflate(R.layout.native_ads_bottom, this);

        img_icon_game = (ImageView) findViewById(R.id.img_icon_game);
        text_title_game = (TextView) findViewById(R.id.text_title_game);
        text_description_game = (TextView) findViewById(R.id.text_description_game);
        tv_download_game = (TextView) findViewById(R.id.tv_download_game);
        icon_download_game = (ImageView) findViewById(R.id.icon_download_game);
        view_download_game = (RelativeLayout) findViewById(R.id.view_download_game);
        layout_content_bottom_native = (LinearLayout) findViewById(R.id.layout_content_bottom_native);

        viewPager = (ViewPager) findViewById(R.id.viewPager);
        viewPager.setClipToPadding(false);
        viewPager.setPadding(30, 0, 30, 0);
        adapter = new AdapterBottomAds(context , listImage);
        viewPager.setAdapter(adapter);
    }

    public void setData(Context context, Data data){
        try {
            adapter.setListImage(data.getMetaData().getMultipleFile().getDataImage());
            adapter.notifyDataSetChanged();
            viewPager.invalidate();

            Glide.with(context).load(data.getMetaData().getLogoImage().getData()).into(img_icon_game);
            text_title_game.setText(data.getMetaData().getShortTitle().getData());
            text_description_game.setText(data.getMetaData().getShortDescription().getData());
            OnClickListener onClickListener = new OnClickListener() {
                @Override
                public void onClick(View view) {
                    String urlClick = data.getMetaData().getCta0().getLink();
                    Intent intent = new Intent(Intent.ACTION_VIEW);
                    intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
                    intent.setData(Uri.parse(urlClick));
                    context.startActivity(intent);
                }
            };
            view_download_game.setOnClickListener(onClickListener);
            tv_download_game.setOnClickListener(onClickListener);
            icon_download_game.setOnClickListener(onClickListener);
            text_title_game.setOnClickListener(onClickListener);
            text_description_game.setOnClickListener(onClickListener);
            img_icon_game.setOnClickListener(onClickListener);
            layout_content_bottom_native.setOnClickListener(onClickListener);

        }catch (Exception e){
            e.printStackTrace();
        }
    }
}
