package playfun.ads.android.sdk.component.model.networkmodel;
import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
public class Limit implements Parcelable {

    @SerializedName("id")
    @Expose
    private Integer id;
    @SerializedName("max_on_day")
    @Expose
    private Integer maxOnDay;
    @SerializedName("distance")
    @Expose
    private Integer distance;

    protected Limit(Parcel in) {
        if (in.readByte() == 0) {
            id = null;
        } else {
            id = in.readInt();
        }
        if (in.readByte() == 0) {
            maxOnDay = null;
        } else {
            maxOnDay = in.readInt();
        }
        if (in.readByte() == 0) {
            distance = null;
        } else {
            distance = in.readInt();
        }
    }

    public static final Creator<Limit> CREATOR = new Creator<Limit>() {
        @Override
        public Limit createFromParcel(Parcel in) {
            return new Limit(in);
        }

        @Override
        public Limit[] newArray(int size) {
            return new Limit[size];
        }
    };

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getMaxOnDay() {
        return maxOnDay;
    }

    public void setMaxOnDay(Integer maxOnDay) {
        this.maxOnDay = maxOnDay;
    }

    public Integer getDistance() {
        return distance;
    }

    public void setDistance(Integer distance) {
        this.distance = distance;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        if (id == null) {
            parcel.writeByte((byte) 0);
        } else {
            parcel.writeByte((byte) 1);
            parcel.writeInt(id);
        }
        if (maxOnDay == null) {
            parcel.writeByte((byte) 0);
        } else {
            parcel.writeByte((byte) 1);
            parcel.writeInt(maxOnDay);
        }
        if (distance == null) {
            parcel.writeByte((byte) 0);
        } else {
            parcel.writeByte((byte) 1);
            parcel.writeInt(distance);
        }
    }
}
