package playfun.ads.android.sdk.component.model.networkmodel;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
public class DataImage implements Parcelable {
    @SerializedName("file")
    @Expose
    private String file;
    @SerializedName("link")
    @Expose
    private String link;

    protected DataImage(Parcel in) {
        file = in.readString();
        link = in.readString();
    }

    public DataImage(String file , String link){
        this.file = file;
        this.link = link;
    }

    public static final Creator<DataImage> CREATOR = new Creator<DataImage>() {
        @Override
        public DataImage createFromParcel(Parcel in) {
            return new DataImage(in);
        }

        @Override
        public DataImage[] newArray(int size) {
            return new DataImage[size];
        }
    };

    public String getFile() {
        return file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getLink() {
        return link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(file);
        parcel.writeString(link);
    }
}
