package playfun.ads.android.sdk.component.model.networkmodel;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class CountDown implements Parcelable {
    @SerializedName("value")
    @Expose
    private Integer value;

    protected CountDown(Parcel in) {
        if (in.readByte() == 0) {
            value = null;
        } else {
            value = in.readInt();
        }
    }

    public static final Creator<CountDown> CREATOR = new Creator<CountDown>() {
        @Override
        public CountDown createFromParcel(Parcel in) {
            return new CountDown(in);
        }

        @Override
        public CountDown[] newArray(int size) {
            return new CountDown[size];
        }
    };

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer value) {
        this.value = value;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        if (value == null) {
            parcel.writeByte((byte) 0);
        } else {
            parcel.writeByte((byte) 1);
            parcel.writeInt(value);
        }
    }
}
