package playfun.ads.android.sdk.component.factory.nativeads.adapter;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;

import com.bumptech.glide.Glide;

import java.util.List;

import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.model.networkmodel.DataImage;

public class AdapterBottomAds extends PagerAdapter{
    List<DataImage> listImage ;
    private LayoutInflater layoutInflater;
    private Context context;

    public AdapterBottomAds(Context context ,List<DataImage> listImage){
        this.listImage = listImage;
        this.context = context;
    }
    @Override
    public int getCount() {
        return listImage.size();
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        return view.equals(object);
    }

    @Override
    public Object instantiateItem(ViewGroup container, int position) {
        layoutInflater = LayoutInflater.from(context);
        View view = layoutInflater.inflate(R.layout.native_ads_item_bottom_ads, container, false);
        ImageView imageView;
        FrameLayout layout_image_bottom_feed;
        imageView = (ImageView) view.findViewById(R.id.image_content);
        layout_image_bottom_feed = (FrameLayout) view.findViewById(R.id.layout_image_bottom_feed);
        if(position == 0){
            layout_image_bottom_feed.setPadding(0 , 0 , 4 , 0);
        }
        if(position == (listImage.size() - 1)){
            layout_image_bottom_feed.setPadding(4 , 0 , 0 , 0);
        }
        Glide.with(context).load(listImage.get(position).getFile()).into(imageView);
        view.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Log.d("TAG" , "click to " + position);
                String urlClick = listImage.get(position).getLink();
                Intent intent = new Intent(Intent.ACTION_VIEW);
                intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
                intent.setData(Uri.parse(urlClick));
                context.startActivity(intent);
            }
        });
        container.addView(view);
        return view;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public void setListImage(List<DataImage> listImage){
        this.listImage = listImage;
    }

}
