
package playfun.ads.android.sdk.component.model.networkmodel;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.List;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class Data implements Parcelable {

    @SerializedName("htmlData")
    @Expose
    private String htmlData;
    @SerializedName("metaData")
    @Expose
    private MetaData metaData;
    @SerializedName("templateType")
    @Expose
    private String templateType;
    private Limit limit;
    @SerializedName("raa_id")
    @Expose
    private Integer raaId;

    public Limit getLimit() {
        return limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Integer getRaaId() {
        return raaId;
    }

    public void setRaaId(Integer raaId) {
        this.raaId = raaId;
    }

    public String getHtmlData() {
        return htmlData;
    }

    public void setHtmlData(String htmlData) {
        this.htmlData = htmlData;
    }

    public MetaData getMetaData() {
        return metaData;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public String getTemplateType() {
        return templateType;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable(metaData,flags);
        out.writeString(htmlData);
        out.writeString(templateType);
    }

    public static final Parcelable.Creator<Data> CREATOR
            = new Parcelable.Creator<Data>() {
        public Data createFromParcel(Parcel in) {
            return new Data(in);
        }

        public Data[] newArray(int size) {
            return new Data[size];
        }
    };

    private Data(Parcel in) {
        metaData = (MetaData) in.readParcelable(MetaData.class.getClassLoader());
        htmlData = in.readString();
        templateType = in.readString();
    }

}
