/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AbstractComponentAdapter;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.ComponentParameter;
import org.picocontainer.defaults.CyclicDependencyException;
import org.picocontainer.defaults.NoSatisfiableConstructorsException;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.TooManySatisfiableConstructorsException;

public class TransientComponentAdapter
extends AbstractComponentAdapter {
    private Parameter[] parameters;
    private List satisfiableConstructors;
    private Constructor greediestConstructor;
    private boolean instantiating;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;

    public TransientComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation);
        this.parameters = parameters;
    }

    public TransientComponentAdapter(Object componentKey, Class componentImplementation) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        this(componentKey, componentImplementation, null);
    }

    public Class[] getDependencies(MutablePicoContainer picoContainer) throws PicoIntrospectionException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Constructor constructor = this.getConstructor(picoContainer);
        return constructor.getParameterTypes();
    }

    private Constructor getConstructor(MutablePicoContainer picoContainer) throws PicoIntrospectionException, NoSatisfiableConstructorsException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (this.greediestConstructor == null) {
            List<Constructor<?>> allConstructors = Arrays.asList(this.getComponentImplementation().getConstructors());
            List satisfiableConstructors = this.getSatisfiableConstructors(allConstructors, picoContainer);
            this.greediestConstructor = null;
            HashSet<Constructor> conflicts = new HashSet<Constructor>();
            for (int i = 0; i < satisfiableConstructors.size(); ++i) {
                Constructor currentConstructor = (Constructor)satisfiableConstructors.get(i);
                if (this.greediestConstructor == null) {
                    this.greediestConstructor = currentConstructor;
                    continue;
                }
                if (this.greediestConstructor.getParameterTypes().length < currentConstructor.getParameterTypes().length) {
                    conflicts.clear();
                    this.greediestConstructor = currentConstructor;
                    continue;
                }
                if (this.greediestConstructor.getParameterTypes().length != currentConstructor.getParameterTypes().length) continue;
                conflicts.add(this.greediestConstructor);
                conflicts.add(currentConstructor);
            }
            if (!conflicts.isEmpty()) {
                throw new TooManySatisfiableConstructorsException(this.getComponentImplementation(), conflicts);
            }
        }
        return this.greediestConstructor;
    }

    private List getSatisfiableConstructors(List constructors, MutablePicoContainer picoContainer) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (this.satisfiableConstructors == null) {
            this.satisfiableConstructors = new ArrayList();
            HashSet<Class> failedDependencies = new HashSet<Class>();
            Iterator iterator = constructors.iterator();
            while (iterator.hasNext()) {
                Constructor constructor = (Constructor)iterator.next();
                Class[] parameterTypes = constructor.getParameterTypes();
                Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
                boolean failedDependency = false;
                for (int i = 0; i < currentParameters.length; ++i) {
                    ComponentAdapter adapter = currentParameters[i].resolveAdapter(picoContainer);
                    if (adapter == null) {
                        failedDependency = true;
                        failedDependencies.add(parameterTypes[i]);
                        break;
                    }
                    if (adapter.equals(this)) {
                        failedDependency = true;
                        failedDependencies.add(parameterTypes[i]);
                        break;
                    }
                    if (!this.getComponentKey().equals(adapter.getComponentKey())) continue;
                    failedDependency = true;
                    failedDependencies.add(parameterTypes[i]);
                    break;
                }
                if (failedDependency) continue;
                this.satisfiableConstructors.add(constructor);
            }
            if (this.satisfiableConstructors.isEmpty()) {
                throw new NoSatisfiableConstructorsException(this.getComponentImplementation(), failedDependencies);
            }
        }
        return this.satisfiableConstructors;
    }

    public Object getComponentInstance(MutablePicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        final Class[] dependencyTypes = this.getDependencies(picoContainer);
        final ComponentAdapter[] adapterDependencies = new ComponentAdapter[dependencyTypes.length];
        final Parameter[] componentParameters = this.getParameters(picoContainer);
        if (componentParameters.length != adapterDependencies.length) {
            throw new PicoInitializationException(){

                public String getMessage() {
                    return "The number of specified parameters (" + componentParameters.length + ") doesn't match the number of arguments in the greediest satisfiable constructor (" + adapterDependencies.length + "). When parameters are explicitly specified, specify them in the correct order, and one for each constructor argument." + "The greediest satisfiable constructor takes the following arguments: " + Arrays.asList(dependencyTypes).toString();
                }
            };
        }
        for (int i = 0; i < adapterDependencies.length; ++i) {
            adapterDependencies[i] = componentParameters[i].resolveAdapter(picoContainer);
        }
        return this.instantiateComponent(adapterDependencies, picoContainer);
    }

    private Object instantiateComponent(ComponentAdapter[] adapterDependencies, MutablePicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        try {
            Constructor constructor = this.getConstructor(picoContainer);
            if (this.instantiating) {
                throw new CyclicDependencyException(constructor);
            }
            this.instantiating = true;
            Object[] parameters = new Object[adapterDependencies.length];
            for (int i = 0; i < adapterDependencies.length; ++i) {
                ComponentAdapter adapterDependency = adapterDependencies[i];
                parameters[i] = adapterDependency.getComponentInstance(picoContainer);
            }
            Object t = constructor.newInstance(parameters);
            return t;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new PicoInvocationTargetInitializationException(e.getTargetException());
        }
        catch (InstantiationException e) {
            throw new PicoInvocationTargetInitializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new PicoInvocationTargetInitializationException(e);
        }
        finally {
            this.instantiating = false;
        }
    }

    public static boolean isAssignableFrom(Class actual, Class requested) {
        if (actual == Character.TYPE || actual == (class$java$lang$Character == null ? (class$java$lang$Character = TransientComponentAdapter.class$("java.lang.Character")) : class$java$lang$Character)) {
            return requested == Character.TYPE || requested == (class$java$lang$Character == null ? (class$java$lang$Character = TransientComponentAdapter.class$("java.lang.Character")) : class$java$lang$Character);
        }
        if (actual == Double.TYPE || actual == (class$java$lang$Double == null ? (class$java$lang$Double = TransientComponentAdapter.class$("java.lang.Double")) : class$java$lang$Double)) {
            return requested == Double.TYPE || requested == (class$java$lang$Double == null ? (class$java$lang$Double = TransientComponentAdapter.class$("java.lang.Double")) : class$java$lang$Double);
        }
        if (actual == Float.TYPE || actual == (class$java$lang$Float == null ? (class$java$lang$Float = TransientComponentAdapter.class$("java.lang.Float")) : class$java$lang$Float)) {
            return requested == Float.TYPE || requested == (class$java$lang$Float == null ? (class$java$lang$Float = TransientComponentAdapter.class$("java.lang.Float")) : class$java$lang$Float);
        }
        if (actual == Integer.TYPE || actual == (class$java$lang$Integer == null ? (class$java$lang$Integer = TransientComponentAdapter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return requested == Integer.TYPE || requested == (class$java$lang$Integer == null ? (class$java$lang$Integer = TransientComponentAdapter.class$("java.lang.Integer")) : class$java$lang$Integer);
        }
        if (actual == Long.TYPE || actual == (class$java$lang$Long == null ? (class$java$lang$Long = TransientComponentAdapter.class$("java.lang.Long")) : class$java$lang$Long)) {
            return requested == Long.TYPE || requested == (class$java$lang$Long == null ? (class$java$lang$Long = TransientComponentAdapter.class$("java.lang.Long")) : class$java$lang$Long);
        }
        if (actual == Short.TYPE || actual == (class$java$lang$Short == null ? (class$java$lang$Short = TransientComponentAdapter.class$("java.lang.Short")) : class$java$lang$Short)) {
            return requested == Short.TYPE || requested == (class$java$lang$Short == null ? (class$java$lang$Short = TransientComponentAdapter.class$("java.lang.Short")) : class$java$lang$Short);
        }
        if (actual == Byte.TYPE || actual == (class$java$lang$Byte == null ? (class$java$lang$Byte = TransientComponentAdapter.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return requested == Byte.TYPE || requested == (class$java$lang$Byte == null ? (class$java$lang$Byte = TransientComponentAdapter.class$("java.lang.Byte")) : class$java$lang$Byte);
        }
        if (actual == Boolean.TYPE || actual == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = TransientComponentAdapter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return requested == Boolean.TYPE || requested == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = TransientComponentAdapter.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        }
        return actual.isAssignableFrom(requested);
    }

    private Parameter[] getParameters(MutablePicoContainer componentRegistry) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (this.parameters == null) {
            return this.createDefaultParameters(this.getDependencies(componentRegistry));
        }
        return this.parameters;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComponentAdapter)) {
            return false;
        }
        ComponentAdapter other = (ComponentAdapter)object;
        return this.getComponentKey().equals(other.getComponentKey()) && this.getComponentImplementation().equals(other.getComponentImplementation());
    }

    private Parameter[] createDefaultParameters(Class[] parameters) {
        Parameter[] componentParameters = new ComponentParameter[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            componentParameters[i] = new ComponentParameter(parameters[i]);
        }
        return componentParameters;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

