/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoException;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.picocontainer.defaults.DefaultComponentMulticasterFactory;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public class DefaultPicoContainer
implements MutablePicoContainer,
Serializable {
    private final List parents = new ArrayList();
    private final Collection children = new ArrayList();
    private final List unmanagedComponents = new ArrayList();
    private final List instantiantionOrderedComponentAdapters = new ArrayList();
    private final ComponentAdapterFactory componentAdapterFactory;
    private final Map componentKeyToAdapterMap = new HashMap();

    public DefaultPicoContainer(ComponentAdapterFactory componentAdapterFactory) {
        this.componentAdapterFactory = componentAdapterFactory;
    }

    public DefaultPicoContainer() {
        this(new DefaultComponentAdapterFactory());
    }

    public final Collection getComponentKeys() {
        HashSet result = new HashSet();
        result.addAll(this.componentKeyToAdapterMap.keySet());
        Iterator iterator = this.parents.iterator();
        while (iterator.hasNext()) {
            DefaultPicoContainer delegate = (DefaultPicoContainer)iterator.next();
            result.addAll(delegate.getComponentKeys());
        }
        return result;
    }

    public List getComponentAdapters() {
        return new ArrayList(this.componentKeyToAdapterMap.values());
    }

    public void registerComponent(ComponentAdapter componentAdapter) throws DuplicateComponentKeyRegistrationException {
        Object componentKey = componentAdapter.getComponentKey();
        if (this.componentKeyToAdapterMap.keySet().contains(componentKey)) {
            throw new DuplicateComponentKeyRegistrationException(componentKey);
        }
        this.componentKeyToAdapterMap.put(componentKey, componentAdapter);
    }

    public Object unregisterComponent(Object componentKey) {
        return this.componentKeyToAdapterMap.remove(componentKey);
    }

    public final ComponentAdapter findComponentAdapter(Object componentKey) throws AmbiguousComponentResolutionException {
        ComponentAdapter result = this.findComponentAdapterImpl(componentKey);
        if (result != null) {
            return result;
        }
        Iterator iterator = this.parents.iterator();
        while (iterator.hasNext()) {
            MutablePicoContainer delegate = (MutablePicoContainer)iterator.next();
            ComponentAdapter componentAdapter = delegate.findComponentAdapter(componentKey);
            if (componentAdapter == null) continue;
            return componentAdapter;
        }
        return null;
    }

    private ComponentAdapter findComponentAdapterImpl(Object componentKey) throws AmbiguousComponentResolutionException {
        ComponentAdapter result = (ComponentAdapter)this.componentKeyToAdapterMap.get(componentKey);
        if (result == null && componentKey instanceof Class) {
            Class classKey = (Class)componentKey;
            result = this.findImplementingComponentAdapter(classKey);
        }
        return result;
    }

    public Object registerComponentInstance(Object component) throws PicoRegistrationException {
        return this.registerComponentInstance(component.getClass(), component);
    }

    public Object registerComponentInstance(Object componentKey, Object componentInstance) throws PicoRegistrationException {
        InstanceComponentAdapter componentAdapter = new InstanceComponentAdapter(componentKey, componentInstance);
        this.registerComponent(componentAdapter);
        this.addOrderedComponentAdapter(componentAdapter);
        this.unmanagedComponents.add(componentInstance);
        return componentKey;
    }

    public Object registerComponentImplementation(Class componentImplementation) throws PicoRegistrationException {
        return this.registerComponentImplementation(componentImplementation, componentImplementation);
    }

    public Object getComponentMulticaster(boolean callInInstantiationOrder, boolean callUnmanagedComponents) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        DefaultComponentMulticasterFactory componentMulticasterFactory = new DefaultComponentMulticasterFactory();
        List componentsToMulticast = this.getComponentInstances();
        if (!callUnmanagedComponents) {
            Iterator iterator = this.unmanagedComponents.iterator();
            while (iterator.hasNext()) {
                componentsToMulticast.remove(iterator.next());
            }
        }
        return componentMulticasterFactory.createComponentMulticaster(this.getClass().getClassLoader(), componentsToMulticast, callInInstantiationOrder);
    }

    public Object getComponentMulticaster() throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        return this.getComponentMulticaster(true, false);
    }

    public Object registerComponentImplementation(Object componentKey, Class componentImplementation) throws PicoRegistrationException {
        return this.registerComponentImplementation(componentKey, componentImplementation, null);
    }

    public Object registerComponentImplementation(Object componentKey, Class componentImplementation, Parameter[] parameters) throws PicoRegistrationException {
        ComponentAdapter componentAdapter = this.componentAdapterFactory.createComponentAdapter(componentKey, componentImplementation, parameters);
        this.registerComponent(componentAdapter);
        return componentKey;
    }

    public void addOrderedComponentAdapter(ComponentAdapter componentAdapter) {
        this.instantiantionOrderedComponentAdapters.add(componentAdapter);
    }

    public List getComponentInstances() throws PicoException {
        Iterator iterator = this.getComponentKeys().iterator();
        while (iterator.hasNext()) {
            this.getComponentInstance(iterator.next());
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator componentAdapters = this.instantiantionOrderedComponentAdapters.iterator();
        while (componentAdapters.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)componentAdapters.next();
            result.add(componentAdapter.getComponentInstance(this));
        }
        return result;
    }

    public Object getComponentInstance(Object componentKey) throws PicoException {
        ComponentAdapter componentAdapter = this.findComponentAdapter(componentKey);
        if (componentAdapter != null) {
            return componentAdapter.getComponentInstance(this);
        }
        return null;
    }

    public Object findComponentInstance(Class componentType) throws PicoException {
        ArrayList foundKeys = new ArrayList();
        Object result = null;
        Iterator iterator = this.getComponentKeys().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object componentInstance = this.getComponentInstance(key);
            if (!componentType.isInstance(componentInstance)) continue;
            result = componentInstance;
            foundKeys.add(key);
        }
        if (foundKeys.size() == 0) {
            return null;
        }
        if (foundKeys.size() > 1) {
            throw new AmbiguousComponentResolutionException(componentType, foundKeys.toArray());
        }
        return result;
    }

    public boolean hasComponent(Object componentKey) {
        return this.getComponentKeys().contains(componentKey);
    }

    public ComponentAdapter findImplementingComponentAdapter(Class componentType) throws PicoException {
        ArrayList<ComponentAdapter> found = new ArrayList<ComponentAdapter>();
        Iterator iterator = this.getComponentAdapters().iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            found.add(componentAdapter);
        }
        if (found.size() == 1) {
            return (ComponentAdapter)found.get(0);
        }
        if (found.size() == 0) {
            return null;
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            ComponentAdapter componentAdapter = (ComponentAdapter)found.get(i);
            foundClasses[i] = componentAdapter.getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    public Collection getChildContainers() {
        return Collections.unmodifiableCollection(this.children);
    }

    public List getParentContainers() {
        return Collections.unmodifiableList(this.parents);
    }

    public void addChild(MutablePicoContainer child) {
        if (!this.children.contains(child)) {
            this.children.add(child);
        }
        if (!child.getParentContainers().contains(this)) {
            child.addParent(this);
        }
    }

    public void addParent(MutablePicoContainer parent) {
        if (!this.parents.contains(parent)) {
            this.parents.add(parent);
        }
        if (!parent.getChildContainers().contains(this)) {
            parent.addChild(this);
        }
    }
}

