/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.tck;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.ConstantParameter;
import org.picocontainer.defaults.CyclicDependencyException;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.NoSatisfiableConstructorsException;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.testmodel.DependsOnTouchable;
import org.picocontainer.testmodel.SimpleTouchable;
import org.picocontainer.testmodel.Touchable;
import org.picocontainer.testmodel.Washable;

public abstract class AbstractPicoContainerTestCase
extends TestCase {
    static /* synthetic */ Class class$org$picocontainer$testmodel$Touchable;
    static /* synthetic */ Class class$org$picocontainer$testmodel$SimpleTouchable;
    static /* synthetic */ Class class$org$picocontainer$testmodel$DependsOnTouchable;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$ListAdder;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$A;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$B;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$C;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$D;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$E;
    static /* synthetic */ Class class$org$picocontainer$testmodel$WashableTouchable;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsWashable;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsTouchable;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$org$picocontainer$tck$AbstractPicoContainerTestCase$JMSService;

    protected abstract MutablePicoContainer createPicoContainer();

    protected final MutablePicoContainer createPicoContainerWithTouchableAndDependency() throws PicoRegistrationException, PicoIntrospectionException {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.registerComponentImplementation((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable), class$org$picocontainer$testmodel$SimpleTouchable == null ? (class$org$picocontainer$testmodel$SimpleTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.SimpleTouchable")) : class$org$picocontainer$testmodel$SimpleTouchable);
        pico.registerComponentImplementation(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable);
        return pico;
    }

    protected final PicoContainer createPicoContainerWithDependsOnTouchableOnly() throws PicoRegistrationException, PicoIntrospectionException {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.registerComponentImplementation(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable);
        return pico;
    }

    public void testNotNull() throws PicoRegistrationException, PicoIntrospectionException {
        AbstractPicoContainerTestCase.assertNotNull((String)"Are you calling super.setUp() in your setUp method?", (Object)this.createPicoContainerWithTouchableAndDependency());
    }

    public void testBasicInstantiationAndContainment() throws PicoException, PicoRegistrationException {
        MutablePicoContainer pico = this.createPicoContainerWithTouchableAndDependency();
        AbstractPicoContainerTestCase.assertTrue((String)"Container should have Touchable component", (boolean)pico.hasComponent((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable)));
        AbstractPicoContainerTestCase.assertTrue((String)"Container should have DependsOnTouchable component", (boolean)pico.hasComponent((Object)(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable)));
        AbstractPicoContainerTestCase.assertTrue((String)"Component should be instance of Touchable", (boolean)(pico.getComponentInstance((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable)) instanceof Touchable));
        AbstractPicoContainerTestCase.assertTrue((String)"Component should be instance of DependsOnTouchable", (boolean)(pico.getComponentInstance((Object)(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable)) instanceof DependsOnTouchable));
        AbstractPicoContainerTestCase.assertTrue((String)"should not have non existent component", (!pico.hasComponent((Object)(class$java$util$Map == null ? (class$java$util$Map = AbstractPicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map)) ? 1 : 0) != 0);
    }

    public void testInstanceRegistration() throws PicoException, PicoInitializationException {
        MutablePicoContainer pico = this.createPicoContainer();
        StringBuffer sb = new StringBuffer();
        pico.registerComponentInstance((Object)sb);
        AbstractPicoContainerTestCase.assertSame((Object)sb, (Object)pico.getComponentInstance((Object)(class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = AbstractPicoContainerTestCase.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer)));
    }

    public void testSerializabilityOfContainer() throws PicoException, PicoInitializationException, IOException, ClassNotFoundException {
        MutablePicoContainer pico = this.createPicoContainerWithTouchableAndDependency();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(pico);
        pico = null;
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        pico = (PicoContainer)ois.readObject();
        DependsOnTouchable dependsOnTouchable = (DependsOnTouchable)pico.getComponentInstance((Object)(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable));
        AbstractPicoContainerTestCase.assertNotNull((Object)dependsOnTouchable);
        SimpleTouchable touchable = (SimpleTouchable)pico.getComponentInstance((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable));
        AbstractPicoContainerTestCase.assertTrue((String)"hello should have been called in Touchable", (boolean)touchable.wasTouched);
    }

    public void testTooFewComponents() throws PicoException, PicoRegistrationException {
        PicoContainer picoContainer = this.createPicoContainerWithDependsOnTouchableOnly();
        try {
            picoContainer.getComponentInstance((Object)(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable));
            AbstractPicoContainerTestCase.fail((String)"should need a Touchable");
        }
        catch (NoSatisfiableConstructorsException e) {
            AbstractPicoContainerTestCase.assertEquals((Object)(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable), (Object)e.getUnsatisfiableComponentImplementation());
        }
    }

    public void testDoubleInstantiation() throws PicoException {
        MutablePicoContainer pico = this.createPicoContainerWithTouchableAndDependency();
        AbstractPicoContainerTestCase.assertSame((Object)pico.getComponentInstance((Object)(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable)), (Object)pico.getComponentInstance((Object)(class$org$picocontainer$testmodel$DependsOnTouchable == null ? (class$org$picocontainer$testmodel$DependsOnTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.DependsOnTouchable")) : class$org$picocontainer$testmodel$DependsOnTouchable)));
    }

    public void testDuplicateRegistration() throws Exception {
        MutablePicoContainer pico = this.createPicoContainerWithTouchableAndDependency();
        try {
            pico.registerComponentImplementation((Object)(class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable), class$org$picocontainer$testmodel$SimpleTouchable == null ? (class$org$picocontainer$testmodel$SimpleTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.SimpleTouchable")) : class$org$picocontainer$testmodel$SimpleTouchable);
            AbstractPicoContainerTestCase.fail((String)"Should have barfed with dupe registration");
        }
        catch (DuplicateComponentKeyRegistrationException e) {
            AbstractPicoContainerTestCase.assertTrue((String)"Wrong key", (e.getDuplicateKey() == (class$org$picocontainer$testmodel$Touchable == null ? (class$org$picocontainer$testmodel$Touchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.Touchable")) : class$org$picocontainer$testmodel$Touchable) ? 1 : 0) != 0);
        }
    }

    public void testByInstanceRegistration() throws PicoException, PicoInitializationException {
        MutablePicoContainer pico = this.createPicoContainerWithTouchableAndDependency();
        pico.registerComponentInstance((Object)(class$java$util$Map == null ? (class$java$util$Map = AbstractPicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map), new HashMap());
        AbstractPicoContainerTestCase.assertEquals((String)"Wrong number of comps in the internals", (int)3, (int)pico.getComponentInstances().size());
        AbstractPicoContainerTestCase.assertEquals((String)"Key - Map, Impl - HashMap should be in internals", (Object)(class$java$util$HashMap == null ? (class$java$util$HashMap = AbstractPicoContainerTestCase.class$("java.util.HashMap")) : class$java$util$HashMap), pico.getComponentInstance((Object)(class$java$util$Map == null ? (class$java$util$Map = AbstractPicoContainerTestCase.class$("java.util.Map")) : class$java$util$Map)).getClass());
    }

    public void testAmbiguousResolution() throws PicoRegistrationException, PicoInitializationException {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.registerComponentImplementation((Object)"ping", class$java$lang$String == null ? (class$java$lang$String = AbstractPicoContainerTestCase.class$("java.lang.String")) : class$java$lang$String);
        pico.registerComponentInstance((Object)"pong", (Object)"pang");
        try {
            pico.getComponentInstance((Object)(class$java$lang$String == null ? (class$java$lang$String = AbstractPicoContainerTestCase.class$("java.lang.String")) : class$java$lang$String));
        }
        catch (AmbiguousComponentResolutionException e) {
            AbstractPicoContainerTestCase.assertTrue((e.getMessage().indexOf("java.lang.String") != -1 ? 1 : 0) != 0);
        }
    }

    public void testNoResolution() throws PicoIntrospectionException, PicoInitializationException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        MutablePicoContainer pico = this.createPicoContainer();
        AbstractPicoContainerTestCase.assertNull((Object)pico.getComponentInstance((Object)(class$java$lang$String == null ? (class$java$lang$String = AbstractPicoContainerTestCase.class$("java.lang.String")) : class$java$lang$String)));
    }

    public void TODOtestMulticasterResolution() throws PicoRegistrationException, PicoInitializationException {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ListAdder == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ListAdder = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ListAdder")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ListAdder);
        pico.registerComponentImplementation((Object)"a", class$java$util$ArrayList == null ? (class$java$util$ArrayList = AbstractPicoContainerTestCase.class$("java.util.ArrayList")) : class$java$util$ArrayList);
        pico.registerComponentImplementation((Object)"l", class$java$util$LinkedList == null ? (class$java$util$LinkedList = AbstractPicoContainerTestCase.class$("java.util.LinkedList")) : class$java$util$LinkedList);
        ListAdder adder = (ListAdder)pico.getComponentInstance((Object)(class$org$picocontainer$tck$AbstractPicoContainerTestCase$ListAdder == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$ListAdder = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$ListAdder")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$ListAdder));
        List a = (List)pico.getComponentInstance((Object)"a");
        AbstractPicoContainerTestCase.assertTrue((boolean)a.contains("something"));
        List l = (List)pico.getComponentInstance((Object)"l");
        AbstractPicoContainerTestCase.assertTrue((boolean)l.contains("something"));
    }

    public void testUnsatisfiedComponentsExceptionGivesVerboseEnoughErrorMessage() {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$A == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$A = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$A")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$A);
        pico.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$B == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$B = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$B")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$B);
        try {
            pico.getComponentInstance((Object)(class$org$picocontainer$tck$AbstractPicoContainerTestCase$A == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$A = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$A")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$A));
        }
        catch (NoSatisfiableConstructorsException e) {
            AbstractPicoContainerTestCase.assertEquals((String)((class$org$picocontainer$tck$AbstractPicoContainerTestCase$A == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$A = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$A")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$A).getName() + " doesn't have any satisfiable constructors. Unsatisfiable dependencies: [class " + (class$org$picocontainer$tck$AbstractPicoContainerTestCase$C == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$C = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$C")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$C).getName() + "]"), (String)e.getMessage());
            Set unsatisfiableDependencies = e.getUnsatisfiableDependencies();
            AbstractPicoContainerTestCase.assertEquals((int)1, (int)unsatisfiableDependencies.size());
            AbstractPicoContainerTestCase.assertTrue((boolean)unsatisfiableDependencies.contains(class$org$picocontainer$tck$AbstractPicoContainerTestCase$C == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$C = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$C")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$C));
        }
    }

    public void testCyclicDependencyThrowsCyclicDependencyException() {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$B == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$B = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$B")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$B);
        pico.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$D == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$D = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$D")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$D);
        pico.registerComponentImplementation(class$org$picocontainer$tck$AbstractPicoContainerTestCase$E == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$E = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$E")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$E);
        try {
            pico.getComponentInstance((Object)(class$org$picocontainer$tck$AbstractPicoContainerTestCase$D == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$D = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$D")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$D));
            AbstractPicoContainerTestCase.fail();
        }
        catch (CyclicDependencyException e) {
            AbstractPicoContainerTestCase.assertEquals((String)("Cyclic dependency: " + (class$org$picocontainer$tck$AbstractPicoContainerTestCase$D == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$D = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$D")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$D).getConstructors()[0].getName() + "(" + (class$org$picocontainer$tck$AbstractPicoContainerTestCase$E == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$E = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$E")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$E).getName() + "," + (class$org$picocontainer$tck$AbstractPicoContainerTestCase$B == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$B = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$B")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$B).getName() + ")"), (String)e.getMessage());
            AbstractPicoContainerTestCase.assertEquals((class$org$picocontainer$tck$AbstractPicoContainerTestCase$D == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$D = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$D")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$D).getConstructors()[0], (Object)e.getConstructor());
        }
        catch (StackOverflowError e) {
            AbstractPicoContainerTestCase.fail();
        }
    }

    public void testSameInstanceCanBeUsedAsDifferentType() {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.registerComponentImplementation((Object)"wt", class$org$picocontainer$testmodel$WashableTouchable == null ? (class$org$picocontainer$testmodel$WashableTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.testmodel.WashableTouchable")) : class$org$picocontainer$testmodel$WashableTouchable);
        pico.registerComponentImplementation((Object)"nw", class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsWashable == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsWashable = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$NeedsWashable")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsWashable);
        pico.registerComponentImplementation((Object)"nt", class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsTouchable == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsTouchable = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$NeedsTouchable")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$NeedsTouchable);
        NeedsWashable nw = (NeedsWashable)pico.getComponentInstance((Object)"nw");
        NeedsTouchable nt = (NeedsTouchable)pico.getComponentInstance((Object)"nt");
        AbstractPicoContainerTestCase.assertSame((Object)nw.washable, (Object)nt.touchable);
    }

    public void testRegisterComponentWithObjectBadType() throws PicoIntrospectionException {
        MutablePicoContainer pico = this.createPicoContainer();
        try {
            pico.registerComponentInstance((Object)(class$java$io$Serializable == null ? (class$java$io$Serializable = AbstractPicoContainerTestCase.class$("java.io.Serializable")) : class$java$io$Serializable), new Object());
            AbstractPicoContainerTestCase.fail((String)"Shouldn't be able to register an Object.class as Serializable because it is not, it does not implement it, Object.class does not implement much.");
        }
        catch (AssignabilityRegistrationException assignabilityRegistrationException) {
            // empty catch block
        }
    }

    public void testPico52() {
        MutablePicoContainer pico = this.createPicoContainer();
        pico.registerComponentImplementation((Object)"foo", class$org$picocontainer$tck$AbstractPicoContainerTestCase$JMSService == null ? (class$org$picocontainer$tck$AbstractPicoContainerTestCase$JMSService = AbstractPicoContainerTestCase.class$("org.picocontainer.tck.AbstractPicoContainerTestCase$JMSService")) : class$org$picocontainer$tck$AbstractPicoContainerTestCase$JMSService, new Parameter[]{new ConstantParameter((Object)"0"), new ConstantParameter((Object)"something")});
        JMSService jms = (JMSService)pico.getComponentInstance((Object)"foo");
        AbstractPicoContainerTestCase.assertEquals((String)"0", (String)jms.serverid);
        AbstractPicoContainerTestCase.assertEquals((String)"something", (String)jms.path);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class JMSService {
        public final String serverid;
        public final String path;

        public JMSService(String serverid, String path) {
            this.serverid = serverid;
            this.path = path;
        }
    }

    public static class NeedsWashable {
        public Washable washable;

        public NeedsWashable(Washable washable) {
            this.washable = washable;
        }
    }

    public static class NeedsTouchable {
        public Touchable touchable;

        public NeedsTouchable(Touchable touchable) {
            this.touchable = touchable;
        }
    }

    public static class E {
        public E(D d) {
        }
    }

    public static class D {
        public D(E e, B b) {
        }
    }

    public static class C {
    }

    public static class B {
    }

    public static class A {
        public A(B b, C c) {
        }
    }

    public static class ListAdder {
        public ListAdder(Collection list) {
            list.add("something");
        }
    }
}

