/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.CachingComponentAdapter;
import org.picocontainer.defaults.CachingComponentAdapterFactory;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapter;
import org.picocontainer.defaults.ConstructorInjectionComponentAdapterFactory;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.picocontainer.defaults.SynchronizedComponentAdapter;
import org.picocontainer.defaults.SynchronizedComponentAdapterFactory;

public class SynchronizedComponentAdapterTestCase
extends TestCase {
    private Runner[] runner = new Runner[3];
    private int blockerCounter = 0;
    static /* synthetic */ Class class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$Blocker;
    static /* synthetic */ Class class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTest(ComponentAdapter componentAdapter) throws InterruptedException {
        int i;
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponentInstance((Object)this);
        pico.registerComponent(componentAdapter);
        this.blockerCounter = 0;
        for (int i2 = 0; i2 < this.runner.length; ++i2) {
            this.runner[i2] = new Runner((PicoContainer)pico);
        }
        Thread[] racer = new Thread[this.runner.length];
        for (i = 0; i < racer.length; ++i) {
            racer[i] = new Thread(this.runner[i]);
        }
        for (i = 0; i < racer.length; ++i) {
            racer[i].start();
            Thread.sleep(250L);
        }
        for (i = 0; i < racer.length; ++i) {
            Thread thread = racer[i];
            synchronized (thread) {
                racer[i].notify();
                continue;
            }
        }
        for (i = 0; i < racer.length; ++i) {
            racer[i].join();
        }
    }

    public void testRaceConditionIsHandledBySynchronizedComponentAdapter() throws InterruptedException {
        int i;
        CachingComponentAdapter componentAdapter = new CachingComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)"key", class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$Blocker == null ? (class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$Blocker = SynchronizedComponentAdapterTestCase.class$("org.picocontainer.defaults.SynchronizedComponentAdapterTestCase$Blocker")) : class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$Blocker));
        SynchronizedComponentAdapter synchronizedComponentAdapter = new SynchronizedComponentAdapter((ComponentAdapter)componentAdapter);
        this.initTest((ComponentAdapter)synchronizedComponentAdapter);
        SynchronizedComponentAdapterTestCase.assertEquals((int)1, (int)this.blockerCounter);
        for (i = 0; i < this.runner.length; ++i) {
            SynchronizedComponentAdapterTestCase.assertNull((Object)this.runner[i].exception);
        }
        for (i = 0; i < this.runner.length; ++i) {
            SynchronizedComponentAdapterTestCase.assertNotNull((Object)this.runner[i].blocker);
        }
        for (i = 1; i < this.runner.length; ++i) {
            SynchronizedComponentAdapterTestCase.assertSame((Object)this.runner[0].blocker, (Object)this.runner[i].blocker);
        }
    }

    public void testRaceConditionIsNotHandledWithoutSynchronizedComponentAdapter() throws InterruptedException {
        CachingComponentAdapter componentAdapter = new CachingComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)"key", class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$Blocker == null ? (class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$Blocker = SynchronizedComponentAdapterTestCase.class$("org.picocontainer.defaults.SynchronizedComponentAdapterTestCase$Blocker")) : class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$Blocker));
        this.initTest((ComponentAdapter)componentAdapter);
        SynchronizedComponentAdapterTestCase.assertNull((Object)this.runner[0].exception);
        SynchronizedComponentAdapterTestCase.assertEquals((int)3, (int)this.blockerCounter);
        for (int i = 1; i < this.runner.length; ++i) {
            SynchronizedComponentAdapterTestCase.assertNull((Object)this.runner[i].exception);
        }
    }

    public void THIS_NATURALLY_FAILS_testSingletonCreationRace() throws InterruptedException {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponentImplementation((Object)"slow", class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor == null ? (class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor = SynchronizedComponentAdapterTestCase.class$("org.picocontainer.defaults.SynchronizedComponentAdapterTestCase$SlowCtor")) : class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor);
        this.runConcurrencyTest(pico);
    }

    public void THIS_NATURALLY_FAILS_testSingletonCreationWithSynchronizedAdapter() throws InterruptedException {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponent((ComponentAdapter)new CachingComponentAdapter((ComponentAdapter)new SynchronizedComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)"slow", class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor == null ? (class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor = SynchronizedComponentAdapterTestCase.class$("org.picocontainer.defaults.SynchronizedComponentAdapterTestCase$SlowCtor")) : class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor))));
        this.runConcurrencyTest(pico);
    }

    public void testSingletonCreationWithSynchronizedAdapterAndDoubleLocking() throws InterruptedException {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponent((ComponentAdapter)new SynchronizedComponentAdapter((ComponentAdapter)new CachingComponentAdapter((ComponentAdapter)new SynchronizedComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)"slow", class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor == null ? (class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor = SynchronizedComponentAdapterTestCase.class$("org.picocontainer.defaults.SynchronizedComponentAdapterTestCase$SlowCtor")) : class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor)))));
        this.runConcurrencyTest(pico);
    }

    public void testSingletonCreationWithSynchronizedAdapterOutside() throws InterruptedException {
        DefaultPicoContainer pico = new DefaultPicoContainer();
        pico.registerComponent((ComponentAdapter)new SynchronizedComponentAdapter((ComponentAdapter)new CachingComponentAdapter((ComponentAdapter)new ConstructorInjectionComponentAdapter((Object)"slow", class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor == null ? (class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor = SynchronizedComponentAdapterTestCase.class$("org.picocontainer.defaults.SynchronizedComponentAdapterTestCase$SlowCtor")) : class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor))));
        this.runConcurrencyTest(pico);
    }

    public void testSingletonCreationWithSynchronizedAdapterOutsideUsingFactory() throws InterruptedException {
        DefaultPicoContainer pico = new DefaultPicoContainer((ComponentAdapterFactory)new SynchronizedComponentAdapterFactory((ComponentAdapterFactory)new CachingComponentAdapterFactory((ComponentAdapterFactory)new ConstructorInjectionComponentAdapterFactory())));
        pico.registerComponentImplementation((Object)"slow", class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor == null ? (class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor = SynchronizedComponentAdapterTestCase.class$("org.picocontainer.defaults.SynchronizedComponentAdapterTestCase$SlowCtor")) : class$org$picocontainer$defaults$SynchronizedComponentAdapterTestCase$SlowCtor);
        this.runConcurrencyTest(pico);
    }

    private void runConcurrencyTest(final DefaultPicoContainer pico) throws InterruptedException {
        int i;
        int size = 10;
        Thread[] threads = new Thread[size];
        final List out = Collections.synchronizedList(new ArrayList());
        for (i = 0; i < size; ++i) {
            threads[i] = new Thread(new Runnable(){

                public void run() {
                    try {
                        out.add(pico.getComponentInstance((Object)"slow"));
                    }
                    catch (Exception e) {
                        out.add(new Date());
                    }
                }
            });
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        ArrayList differentInstances = new ArrayList();
        for (int i2 = 0; i2 < out.size(); ++i2) {
            Object o = out.get(i2);
            if (differentInstances.contains(o)) continue;
            differentInstances.add(o);
        }
        SynchronizedComponentAdapterTestCase.assertTrue((String)("Only one singleton instance was created [we have " + differentInstances.size() + "]"), (differentInstances.size() == 1 ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class SlowCtor {
        public SlowCtor() throws InterruptedException {
            Thread.sleep(50L);
        }
    }

    public class Blocker {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Blocker() throws InterruptedException {
            Thread thread;
            Thread thread2 = thread = Thread.currentThread();
            synchronized (thread2) {
                SynchronizedComponentAdapterTestCase.this.blockerCounter++;
                thread.wait();
            }
        }
    }

    class Runner
    implements Runnable {
        public RuntimeException exception;
        public Blocker blocker;
        private PicoContainer pico;

        public Runner(PicoContainer pico) {
            this.pico = pico;
        }

        public void run() {
            try {
                this.blocker = (Blocker)this.pico.getComponentInstance((Object)"key");
            }
            catch (RuntimeException e) {
                this.exception = e;
            }
        }
    }
}

